# This module patches the Result object returned by Sphincter so that it meets
# the API expected by will_paginate.
module SphincterWillPaginate
    
  def search_with_will_paginate_wrapper(query, options = {})
    results = search_without_will_paginate_wrapper(query, options)
    
    # add the required methods
    class <<results
      attr_accessor :current_page
      def page_count
        (total / per_page).ceil + 1 # starting from 1
      end
      def previous_page
        current_page > 1 ? current_page - 1 : nil
      end
      def next_page
        current_page < page_count ? current_page + 1 : nil
      end
    end
    
    results.current_page = options.key?(:page) ? options[:page] : 1
    
    results
  end
  
  def self.included(base)
    base.send :alias_method_chain, :search, :will_paginate_wrapper  
  end
  
end