# http://lunchroom.lunchboxsoftware.com/pages/specifications/
module Specification
  def satisfies(name, msg, &block)
    (@specifications ||= {})[name] = {:msg => msg, :block => block}
  end

  def passes_all?(*args)
    @failures = @specifications.reject {|m,hsh| hsh[:block].call(*args) }
    @failures.size == 0
  end

  def failures
    @failures.map {|name,hsh| hsh[:msg]}
  end

  def method_missing(method, *args) #:nodoc:
    @specifications[method][:block].call(*args)
  end
end