# http://www.columbia.edu/kermit/postal-ca.html
# http://en.wikipedia.org/wiki/Canadian_postal_code
#
# Special cases not observed:
#  K1A Federal government in Ottawa-Gatineau
#  H0H 0H0
#
# TODO move this into a plugin
module PostalCode  
  # returns the province code matching the given postal code, or nil, if no match found
  def PostalCode.province(postal_code)
    case postal_code
      when /^A/           then "NL"
      when /^B/           then "NS"
      when /^C/           then "PE"
      when /^E/           then "NB"
      when /^[G|H|J]/     then "QC"
      when /^[K|L|M|N|P]/ then "ON"
      when /^R/           then "MB"
      when /^S/           then "SK"
      when /^T/           then "AB"
      when /^V/           then "BC"
      when /^X0[A|B|C]/   then "NU" 
      when /^X/           then "NT" 
      when /^Y/           then "YT"
    end      
  end
end