class ReorderRatingValues < ActiveRecord::Migration
  def self.up
    # reverse values, except 77 and 0
    [CommentRating, TopicRating, MaterialInformativeRating].each do | rating_class |
      say_with_time "Updating #{rating_class} values..." do
        rating_class.update_all('value = (value * -1) + 5', 'value !=77 AND value != 0')
      end
    end
    
    # recalculate rating-dependant values
    say_with_time "Updating Comment average_rating_cache..." do
      Comment.update_all('avg_rating = (avg_rating * -1) + 5', 'avg_rating != 0')
    end
    say_with_time "Updating RegisteredUser average_rating_cache..." do
      Comment.update_all('avg_rating = (avg_rating * -1) + 5', 'avg_rating != 0')
    end
  end

  def self.down
    self.up # same drill
  end
end
