class AddIndexes < ActiveRecord::Migration
  def self.up
    add_index "comments", ["created_by"], :name => "index_comments_on_created_by"
    add_index "comments", ["topic_id"], :name => "index_comments_on_topic_id"
    add_index "comments", ["created_at"], :name => "index_comments_on_created_at"

    add_index "ratings", ["participant_id"], :name => "index_ratings_on_participant_id"
    add_index "ratings", ["created_on"], :name => "index_ratings_on_created_on"

    add_index "readings", ["participant_id"], :name => "index_readings_on_participant_id"
    add_index "readings", ["readable_id", "readable_type"], :name => "index_readings_on_readable"
  end

  def self.down
    remove_index "comments", "created_by"
    remove_index "comments", "topic_id"
    remove_index "comments", "created_at"
                 
    remove_index "ratings", "participant_id"
    remove_index "ratings", "created_on"
                            
    remove_index "readings", "participant_id"
    remove_index "readings", "readable"
  end
end
