class TopicDatesAreRanges < ActiveRecord::Migration
  def self.up
    add_column :topics, :end_date, :date, :null => false
    # rename_column :topics, 'for', :start_date
    execute "ALTER TABLE topics CHANGE `for` `start_date` date"
    Topic.reset_column_information
    say_with_time "Setting topic end_dates..." do
      Topic.find(:all).each do |t|
        t.update_attribute(:end_date, t.start_date)
      end
    end
  end

  def self.down
    remove_column :topics, :end_date
    # rename_column :topics, :start_date, 'for'
    execute "ALTER TABLE topics CHANGE `start_date` `for` date"
  end
end
