class UserNotifier < ActionMailer::Base
  def signup_notification(user)
    setup_email(user)
    bcc         "pierre.killeen@gmail.com, lee@omara.ca"
    @subject    += 'Thank you for registering' # TODO translation required
    @body[:url]  = [Settings.application_url, 'verify', user.login_key].join("/")
  end
  
  def password_reminder(user)
    setup_email(user)
    @subject   += 'Password reminder' # TODO translation required
    @body[:url]  = Settings.application_url 
  end
    
  # the notice sent to the writter of the comment being replied to
  def reply_notification(user, comment)
    setup_email(user)
    @subject   += "A new reply"
    @body[:url] = "#{Settings.application_url}/topics/show/#{comment.topic_id}#comment_#{comment.id}"
  end
  
  # Deliver general_message to many users
  def UserNotifier.gereral_message_many_users(user_list, message_subject, message_body)
    # breakpoint
    user_list.each do |to|
      UserNotifier::deliver_general_message(to, message_subject, message_body)
    end
  end
  
  def general_message(to, message_subject, message_body)
    # breakpoint
    recipients  to.email_address_with_name
    from        Settings.admin_email
    subject     message_subject
    sent_on     Time.now
    @body[:message] = message_body.gsub('{{user_name}}', to.name || 'valued user')
  end
  
  protected
  def setup_email(user)
    recipients  user.email_address_with_name
    from        Settings.admin_email
    subject     "[%s] " % Settings.email_subject_label
    sent_on     Time.now
    body        :user => user
  end
end
