# Schema as of Fri Jun 29 21:58:21 EDT 2007 (schema version 45)
#
#  id                  :integer(11)   not null
#  value               :integer(11)   default(0), not null
#  subject_id          :integer(11)   default(0), not null
#  participant_id      :integer(11)   
#  created_on          :datetime      not null
#  type                :string(255)   
#

class MaterialInformativeRating < AbstractRating
  belongs_to :subject, :class_name => 'SupportMaterial', :foreign_key => 'subject_id'
  
  def mapping # Agree (4), Somewhat Agree (3), Unsure (77) Somewhat Disagree (2) Disagree (1)
    # TODO these strings should be stored as application settings
    [ 
      [4, 'informative'],
      [3, 'somewhat informative'], 
      [77, 'unsure'],
      [2, 'somewhat uninformative'],
      [1, 'uninformative']
    ]
  end
  
  class << self
    def report(topic_id=nil)
      if topic_id
        topic_condition = "AND support_materials.topic_id = #{topic_id}"
        report_raw("SELECT #{selected_fields} FROM ratings INNER JOIN support_materials ON ratings.subject_id = support_materials.id WHERE #{type_restriction} #{topic_condition} ORDER BY created_on")        
      else
        report_raw("SELECT #{selected_fields} FROM ratings WHERE #{type_restriction} ORDER BY created_on")
      end
    end    
  end
  
end
