class SearchController < ApplicationController
  
  helper :comment
  
  def index
    @title = "Search Results for: #{params[:terms]}"
    if params[:terms].nil? || params[:terms].empty?
      flash[:notice] = 'please enter a search term'
    else
      @topic_results   = Topic::search(params[:terms], page)
      @topic_total     = @topic_results.total
      @topics          = @topic_results.records
      
      # TODO would be nice to see comments from topics current_user has access to
      @comment_results = Comment::search(params[:terms], page) 
      @comment_total   = @comment_results.total
      @comments        = @comment_results.records
    end
  end
  
  def page
    if params[:page] && params[:page].to_i
      {:page => params[:page].to_i}
    else
      {}
    end
  end
end