class MetricsController < ApplicationController
  layout "admin"

  before_filter :permision_required, :set_breadcrumb
  
  def index
    @report = MetricsReport::Aggregate.new(params)
    @title = "Metrics: All topics"
  end
  
  # Show a set of metrics scopped to a particular topic -- we don't care about inter-topic 
  # comparissons here
  def show
    if (params[:id].nil? || params[:id] == "0")
      redirect_to :action => 'index'
      return
    end
    @report = MetricsReport::Aggregate.new(params)
    @title = "Metrics: #{@report.topic.title}"
    @breadcrumb_trail << @report.topic.title 
  end
  
  def export_html
    @title = "#{params[:model].humanize} Data"
    @table = MetricsReport::Export.new(params)
    if @table.topic
      @breadcrumb_trail << [@table.topic.title, url_for(:controller => self.controller_name, :action => 'show', :id => params[:id])]
    end
    @breadcrumb_trail << @title 
  end
  
  def export_csv
    table = MetricsReport::Export.new(params)
    send_data table.as(:csv), 
      :type => 'text/csv',
      :disposition => 'attachment', 
      :filename => "export-#{params[:model]}.csv"
  end
  
  def top5
    @top5 = MetricsReport::Top5.new(params)
    render :layout => false
  end
  
  private
  
  def action_requires_permission?
    true
  end
  
  def set_breadcrumb
    set_default_breadcrumb
    if action_name == 'index'
      @breadcrumb_trail << controller_name.titleize 
    else
      @breadcrumb_trail << [controller_name.titleize, url_for(:controller => self.controller_name, :action => 'index')] 
    end
  end
  
end # class

