# Must be a registered user.
class AvatarsController < ApplicationController
  before_filter :redirect_guest_to_root
  
  def index
    redirect_to :action => 'new'
  end
  
  def show
    redirect_to :action => 'new'
  end
  
  def new
    @avatar = Avatar.new(:user => current_user)
  end
  
  def create
    @avatar = current_user.build_avatar(params[:avatar])
    if @avatar.save
      flash[:notice] = 'Avatar was successfully created.'
    end
    render :action => 'new'
  end
  
  def remove
    if current_user.avatar.destroy
      flash[:notice] = 'Avatar was successfully removed.'
    end
    redirect_to :action => 'new'
  end
  
  def redirect_guest_to_root
    redirect_to '/' and return false if current_user.guest?
  end
end