# Filters added to this controller will be run for all controllers in the application.
# Likewise, all the methods added will be available for all controllers.
class ApplicationController < ActionController::Base
  [ExceptionLoggable, AuthenticatedSystem, PermissionSystem].each { |mod| include mod }
  
  before_filter :login_required, :setup_userstamp, :logout_suspended_users
  before_filter :disable_participation_when_closed
  
  session :session_key => 'ses_session_id'
  
  helper UniformLinkHelper
  helper RaterHelper
  helper AvatarsHelper
  
  protected
  
  # for userstamp plugin
  def setup_userstamp
    User.current_user = current_user
  end
  
  def disable_participation_when_closed
    unless ApplicationPolicy::participation_enabled? || ApplicationPolicy::user_can_view_closed_application?(current_user)
      reset_session
      flash[:alert] = "The consultation is not operating at this time"
      redirect_to :controller => "/account", :action => 'login'
      return false 
    end
  end
       
  def guest?
    current_user.instance_of? Guest
  end

  # if a user gets flagged as 'suspended' while they are already in session, kick them out
  def logout_suspended_users
    if current_user.suspended? 
      reset_session
      redirect_to logout_url
      return false
    end
  end

  def admin_or_application_layout
    action_requires_permission? ? 'admin' : 'application'
  end
  
  
  def set_default_breadcrumb
    @breadcrumb_trail = [['Home', '/']]
  end

  def set_breadcrumb
    set_default_breadcrumb
    if action_name == 'index'
      @breadcrumb_trail << controller_name.titleize 
    else
      @breadcrumb_trail << [controller_name.titleize, url_for(:controller => self.controller_name, :action => 'index')] << action_name.titleize
    end
  end
  
end
