;
; Plots location of MXD grid boxes with complete 1697-1976 data,
; differentiating those that were infilled.
;
restore,'mxd_infill.idlsave'
fd=fltarr(g.nx,g.ny)*!values.f_nan
for i = 0 , maxbox-1 do fd(keepi(i),keepj(i))=1.
for i = 0 , n_elements(baselist)-1 do $
  fd(keepi(baselist(i)),keepj(baselist(i)))=2.
;
dummy=where(finite(fd),nbox)
;
loadct,39
def_1color,cr,cg,cb,10,color='red'
def_1color,cr,cg,cb,11,color='red'
multi_plot,nrow=1
if !d.name eq 'PS' then begin
  !p.font=0
  device,/bold,/helvetica,font_size=16
endif
;
map=def_map(/npolar)  &  map.limit(0)=25.
labels=def_labels(/off)
;
inter_boxfd,fd,g.x,g.y,levels=[0.5,1.5,2.5],c_colors=[11,10],$
  labels=labels,map=map
;
xyouts,-180.,15.,align=0.5,$
  string(nbox,format='(I3)')+' grid boxes with!Ccomplete 1697-1976 data (280 yr)'
;
end
