;
; Plots location of MXD grid boxes with complete 1697-1976 data,
; differentiating those that were infilled.  And this version also
; shows (different colour) those that were obtained by PCR.
;
doinfill=1    ; 0=don't mark infilled boxes, 1=do, 2=do, with same colour
trv=0           ; selects tree-ring-variable: 0=MXD 1=TRW
case trv of
  0: begin
    fnadd='mxd'
    end
  1: begin
    fnadd='trw'
    end
endcase
titadd=strupcase(fnadd)
;
; First get the PCR-extended data (not ABD low-freq, which has a slightly
; different spatial coverage, due to different successes/failures during
; the PCR verification).
;
restore,filename='calib'+fnadd+'5_pcr.idlsave'
fdpcr=fdcalibpcr
yrpcr=mxdyear
;
restore,fnadd+'_infill.idlsave'
;
shyr=[1950,1400,1583,1697]
shyr=[1950,1822,1743,1697,1660,1583,1453,1400]
nshow=n_elements(shyr)
;
titpt='('+['b','d','f','h','j','l','n','p']+') '
;
loadct,39
multi_plot,nrow=4,ncol=1,layout='large'
if !d.name eq 'X' then begin
  window,ysize=750
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=14
endelse
def_1color,cr,cg,cb,10,color='black'
def_1color,cr,cg,cb,11,color='mgrey'
def_1color,cr,cg,cb,12,color='mdgrey'
;
map=def_map(/npolar)  &  map.limit(0)=25.
map.xmargin=[0,0] & map.ymargin=[0,0]
labels=def_labels(/off)
coast=def_coast(/get_device) & coast.thick=[0.5,2]
;coast.color=12
;
for i = 0 , nshow-1 do begin
  ;
  iyr=where(mxdyear eq shyr(i))
  fd1=reform(mxdfd(*,*,iyr))
  fd2=reform(mxdfd2(*,*,iyr))
  ;
  iyr=where(yrpcr eq shyr[i])
  fd3=reform(fdpcr[*,*,iyr])
  ;
  fd=fd1
  fd(*,*)=!values.f_nan
  ;
  fd(where(finite(fd3)))=doinfill
  ;
  fd(where(finite(fd2)))=2.
;  fd(where(finite(fd2)))=1.
;  fd(where(finite(fd2)))=doinfill
  ;
  fd(where(finite(fd1)))=2.
  ;
  print,shyr[i],total(finite(fd1)),total(finite(fd2)),total(finite(fd3))
  ;
  inter_boxfd,fd,g.x,g.y,levels=[0.5,1.5,2.5],c_colors=[11,10],$
    labels=labels,map=map,coast=coast
  ;
  xyouts,-55,25,titpt[i]+string(shyr(i),format='(I4)')
  ;
endfor
;
end
