;
; For the full MXD mask (i.e. 1950 coverage), output the mask, and also create
; a matching mask on the HadCM3 grid.
; For earlier periods, there is the option to include or exclude the infilled boxes
; from the mask!
;
doinfill=0      ; 0=don't include infilled boxes, 1=do include infilled boxes but
                ; mark them grey in the plots on original grid, 2=do include infilled
                ; boxes and do not distinguish them from other boxes
;
doregion=1     ; 0=don't distinguish regions, 1=do distinguish regions
if doregion gt 0 then fnreg='_regions' else fnreg=''
;
trv=0           ; selects tree-ring-variable: 0=MXD 1=TRW
case trv of
  0: begin
    fnadd='mxd'
    end
  1: begin
    fnadd='trw'
    end
endcase
titadd=strupcase(fnadd)
;
restore,fnadd+'_infill.idlsave'
;
shyr=[1500,1600,1700,1800,1950]
shyr=[1950]
nshow=n_elements(shyr)
;
loadct,39
multi_plot,nrow=2,ncol=1,layout='large'
if !d.name eq 'X' then begin
  window,ysize=750
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=16
endelse
def_1color,cr,cg,cb,10,color='black'
def_1color,cr,cg,cb,11,color='mgrey'
def_1color,20,color='red'
def_1color,21,color='green'
def_1color,22,color='brightblue'
def_1color,23,color='magenta'
def_1color,24,color='brown'
def_1color,25,color='vlpurple'
def_1color,26,color='mblue'
def_1color,27,color='orange'
def_1color,28,color='dred'
;
map=def_map(/npolar)  &  map.limit(0)=20.
map.xmargin=[0,0] & map.ymargin=[0,0]
labels=def_labels(/off)
coast=def_coast(/get_device) & coast.thick=[0.5,2]
coast.color=12
;
for i = 0 , nshow-1 do begin
  tityr=string(shyr(i),format='(I4)')
  ;
  iyr=where(mxdyear eq shyr(i))
  fd1=reform(mxdfd(*,*,iyr))
  fd2=reform(mxdfd2(*,*,iyr))
  fd=fd1
  fd(*,*)=!values.f_nan
;  fd(where(finite(fd2)))=1.
  if doinfill gt 0 then fd(where(finite(fd2)))=doinfill
  fd(where(finite(fd1)))=2.
  nbox=total(finite(fd))
  ;
  if doregion gt 0 then begin
    regname=['NEUR','SEUR','NSIB','ESIB','CAS','TIBP','WNA','NWNA','ECCA']
    nreg=n_elements(regname)
    x=fltarr(g.nx,g.ny)
    for iy = 0 , g.ny-1 do x[*,iy]=g.x[*]
    y=fltarr(g.nx,g.ny)
    for ix = 0 , g.nx-1 do y[ix,*]=g.y[*]
    fdreg=fd*0
    for ireg = 0 , nreg-1 do begin
      case ireg of
        0: kl=where(((x ge -15) and (x le 30) and (y ge 53)) $
          or ((x ge -15) and (x le 61) and (y ge 60)))
        1: kl=where((x ge -15) and (x le 30) and (y lt 53))
        2: kl=where((x gt 61) and (x le 128) and (y ge 60))
        3: kl=where((x gt 128) and (y ge 60))
        4: kl=where((x gt 30) and (x le 115) and (y lt 60) and (y ge 40))
        5: kl=where((x ge 60) and (x le 115) and (y lt 40))
        6: kl=where((x ge -135) and (x le -100) and (y lt 50.))
        7: kl=where(((x ge -170) and (x le -125) and (y ge 50.)) $
          or ((x ge -170) and (x le -120) and (y ge 50) and (y lt 60)) $
          or ((x ge -170) and (x le -105) and (y ge 50) and (y lt 55)))
        8: kl=where(((x gt -100) and (x le -45) and (y ge 40)) $
          or ((x gt -105) and (x le -45) and (y ge 50.)) $
          or ((x gt -120) and (x le -45) and (y ge 55.)) $
          or ((x gt -125) and (x le -45) and (y ge 60.)))
      endcase
      fdreg[kl]=fdreg[kl]+ireg+1
    endfor
    fd=fdreg
    levs=findgen(nreg+1)+0.5
    cols=indgen(nreg)+20
  endif else begin
    levs=[0.5,1.5,2.5]
    cols=[11,10]
  endelse
;  pause
;  qtv,reverse(fdreg,2),/scale,range=[0,10]
  ;
  pause
  inter_boxfd,fd,g.x,g.y,levels=levs,c_colors=cols,$
    labels=labels,map=map,coast=coast,fdsm=fdsm
  fdboxes=fdsm.fd
  fdboxes[*,*]=4
  fdboxes[where(finite(fdsm.fd))]=1.
  boxplot,fdboxes,fdsm.x,fdsm.y,/overmap,/overplot,highlight=fdboxes,$
    thick=1,color=11
  ;
  xyouts,-55,25,tityr+string(nbox,format='(I4)')
  ;
  ; Output mask to a file
  ;
  openw,1,'mxdmask'+tityr+fnreg+'_on_crutem2grid.dat'
  printf,1,'This is the mask of the gridded MXD data set on the CRUTEM1 grid.'
  printf,1,'THIS MASK CORRESPONDS WITH THE COVERAGE OF MXD DATA AVAILABLE'
  printf,1,'BACK TO THE YEAR '+tityr+' (ALL YEARS BETWEEN 1870 AND 1976 HAVE'
  printf,1,'MAXIMUM COVERAGE)'
  printf,1
  if (shyr[i] ge 1870) and (shyr[i] le 1976) then begin
    printf,1,'Observed land air temperatures (CRUTEM1) were taken from these grid'
    printf,1,'boxes (where available - note that many values were missing early on'
    printf,1,'in the higher latitudes particularly) to form the "ALL" area average'
    printf,1,'(area weighted).'
    printf,1
    printf,1,'The "ALL" series was reconstructed back to 1400 using the MXD data'
    printf,1,'set, though the coverage of the MXD data reduces rapidly back in time.'
    printf,1
  endif
  printf,1,'The order of the mask is from the NW corner, westwards then southwards,'
  printf,1,'finishing at the SE corner.  Only the NH is included here.'
  printf,1
  printf,1,'Coordinates of the centre of each grid box are:'
  printf,1
  printf,1,'Longitudes:'
  printf,1,g.x,format='(10F8.2)'
  printf,1
  printf,1,'Latitudes:'
  printf,1,g.y,format='(10F8.2)'
  printf,1
  if doregion eq 0 then begin
    printf,1,'Mask (0=not in ALL mask because no MXD data, 1=in ALL mask)'
    printf,1,finite(fd),format='(72I1)'
  endif else begin
    printf,1,'Mask key:'
    printf,1,'  0=not in mask because no MXD data'
    for ireg = 0 , nreg-1 do begin
      printf,1,ireg+1,regname[ireg],format='(I3,"=in region ",A)'
    endfor
    printf,1,fd,format='(72I1)'
  endelse
  close,1
  ;
  ; Next, make an equivalent mask but on the HadCM3 grid.  Various possibilities
  ; exist, but here if the centre of the HadCM3 grid box falls within a box
  ; that is in the mask on the CRUTEM grid, then it is in the mask on the HadCM3
  ; grid.
  ;
  ghc3=def_grid(/hadcm3)
  fdhc3=fltarr(ghc3.nx,ghc3.ny)*!values.f_nan
  for ix = 0 , ghc3.nx-1 do begin
    distx=standard_lon(g.x,/nosort)-standard_lon(ghc3.x[ix])
    nearx=min(abs(distx),ixnear)
    if nearx gt 2.5 then print,'StrangeX:',nearx,g.x[ixnear],ghc3.x[ix]
    for iy = 0 , ghc3.ny-1 do begin
      disty=g.y-ghc3.y[iy]
      neary=min(abs(disty),iynear)
      if (ix eq 0) and (neary gt 2.5) and (ghc3.y[iy] gt 0) then $
        print,'StrangeY:',neary,g.y[iynear],ghc3.y[iy]
      if finite(fd[ixnear,iynear]) then fdhc3[ix,iy]=1.
    endfor
  endfor
  ;
  if doregion gt 0 then begin
    regname=['NEUR','SEUR','NSIB','ESIB','CAS','TIBP','WNA','NWNA','ECCA']
    nreg=n_elements(regname)
    x=fltarr(ghc3.nx,ghc3.ny)
    for iy = 0 , ghc3.ny-1 do x[*,iy]=ghc3.x[*]
    y=fltarr(ghc3.nx,ghc3.ny)
    for ix = 0 , ghc3.nx-1 do y[ix,*]=ghc3.y[*]
    sublist=where(x gt 180.)
    x[sublist]=x[sublist]-360
    fdreg=fdhc3*0
    for ireg = 0 , nreg-1 do begin
      case ireg of
        0: kl=where(((x ge -15) and (x le 30) and (y ge 53)) $
          or ((x ge -15) and (x le 61) and (y ge 60)))
        1: kl=where((x ge -15) and (x le 30) and (y lt 53))
        2: kl=where((x gt 61) and (x le 128) and (y ge 60))
        3: kl=where((x gt 128) and (y ge 60))
        4: kl=where((x gt 30) and (x le 115) and (y lt 60) and (y ge 40))
        5: kl=where((x ge 60) and (x le 115) and (y lt 40))
        6: kl=where((x ge -135) and (x le -100) and (y lt 50.))
        7: kl=where(((x ge -170) and (x le -125) and (y ge 50.)) $
          or ((x ge -170) and (x le -120) and (y ge 50) and (y lt 60)) $
          or ((x ge -170) and (x le -105) and (y ge 50) and (y lt 55)))
        8: kl=where(((x gt -100) and (x le -45) and (y ge 40)) $
          or ((x gt -105) and (x le -45) and (y ge 50.)) $
          or ((x gt -120) and (x le -45) and (y ge 55.)) $
          or ((x gt -125) and (x le -45) and (y ge 60.)))
      endcase
      fdreg[kl]=fdreg[kl]+ireg+1
    endfor
    fdhc3=fdreg
  endif
  ;
  pause
  inter_boxfd,fdhc3,ghc3.x,ghc3.y,levels=levs,c_colors=cols,$
    labels=labels,map=map,coast=coast,fdsm=fdsm
  nbox=total(finite(fdhc3))
  fdboxes=fdsm.fd
  fdboxes[*,*]=4
  fdboxes[where(finite(fdsm.fd))]=1.
  boxplot,fdboxes,fdsm.x,fdsm.y,/overmap,/overplot,highlight=fdboxes,$
    thick=1,color=11
  ;
  xyouts,-55,25,tityr+string(nbox,format='(I4)')
  ;
  ; Output mask to a file
  ;
  openw,1,'mxdmask'+tityr+fnreg+'_on_hadcm3grid.dat'
  printf,1,'This is the mask of the gridded MXD data set on the HadCM3 grid.'
  printf,1,'THIS MASK CORRESPONDS WITH THE COVERAGE OF MXD DATA AVAILABLE'
  printf,1,'BACK TO THE YEAR '+tityr+' (ALL YEARS BETWEEN 1870 AND 1976 HAVE'
  printf,1,'MAXIMUM COVERAGE)'
  printf,1
  if (shyr[i] ge 1870) and (shyr[i] le 1976) then begin
    printf,1,'Land air temperatures should be taken from these grid boxes to form'
    printf,1,'an equivalent of the observed "ALL" area average (area weighted).'
    printf,1,'Not sure what you should do about boxes in this mask that HadCM3'
    printf,1,'classes as ocean - use them or exclude them?'
    printf,1
  endif
  printf,1,'The order of the mask is from the NW corner, westwards then southwards,'
  printf,1,'finishing at the SE corner.  Both hemispheres are included here.'
  printf,1
  printf,1,'Coordinates of the centre of each grid box are:'
  printf,1
  printf,1,'Longitudes:'
  printf,1,ghc3.x,format='(10F8.2)'
  printf,1
  printf,1,'Latitudes:'
  printf,1,ghc3.y,format='(10F8.2)'
  printf,1
  if doregion eq 0 then begin
    printf,1,'Mask (0=not in ALL mask because no MXD data, 1=in ALL mask)'
    printf,1,finite(fdhc3),format='(96I1)'
  endif else begin
    printf,1,'Mask key:'
    printf,1,'  0=not in mask because no MXD data'
    for ireg = 0 , nreg-1 do begin
      printf,1,ireg+1,regname[ireg],format='(I3,"=in region ",A)'
    endfor
    printf,1,fdhc3,format='(96I1)'
  endelse
  close,1
  ;
endfor
;
end
