;
; Plots regional temperature series, to compare the variance-adjusted
; and non-variance adjusted versions
;
restore,filename='regbest_mxd_fixed1950.idlsave'
; Gets: nreg,regname,regtemp,rawtemp,timey etc.
;
loadct,39
multi_plot,nrow=5,layout='large'
if !d.name eq 'X' then begin
  window,ysize=850
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=9
endelse
def_1color,10,color='blue'
;
for ireg = 0 , nreg-1 do begin
  pause
  msk=float(finite(regtemp(*,ireg)))
  ml=where(msk eq 0,nmiss)
  if nmiss gt 0 then msk(ml)=!values.f_nan
  plot,timey,rawtemp(*,ireg)*msk,$
    /xstyle,xtitle='Year',$
    ytitle='Temperature anomaly  (!Uo!NC)',$
    title=regname(ireg)+': raw vs. adjusted'
  oplot,timey,regtemp(*,ireg),color=10,thick=2
  oplot,!x.crange,[0.,0.],linestyle=1
endfor
;
end
