;
; Plots a map showing location of all MXD chronologoes
;
dogen=0       ; 0=blobs 1=genus
;
restore,filename='allmxd.idlsave'
;  nchron,idno,idname,location,country,tree,yrstart,yrend,statlat,statlon,$
;  mxd,fraction,timey,nyr
;
; ouput lats and lons to a file for Julie Jones
;
openw,1,'treecoords_julie.dat'
printf,1,'Latitude and longitudes of tree-ring chronology sites in the'
printf,1,'Schweingruber density&width data set'
printf,1,nchron,' = Number of sites'
printf,1,'  Latitude Longitude'
for i = 0 , nchron-1 do printf,1,statlat[i],statlon[i],format='(2F10.2)'
close,1
;
loadct,39
def_1color,20,color='green'
multi_plot,nrow=1
if !d.name eq 'X' then begin
  window,xsize=700,ysize=700
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=16
  if dogen eq 1 then device,bold=0,font_size=2
endelse
;
map=def_map(/npolar)  &  map.limit(0)=25.
coast=def_coast(/off)
labels=def_labels(/off)
;
inter_boxfd,/nodata,map=map,coast=coast,labels=labels,$
  title='Location of tree-ring density chronologies'
map_continents,/coasts,color=!p.color,mlinethick=0.5
map_continents,/countries,color=!p.color,mlinestyle=1,mlinethick=0.5
;
if dogen eq 0 then begin
  cpl_usersym,/circle,/fill
  plots,statlon,statlat,psym=8,color=20,symsize=0.7
  cpl_usersym,/circle
  plots,statlon,statlat,psym=8,thick=2,symsize=0.7
endif else begin
  for i = 0 , nchron-1 do begin
    xyouts,statlon(i),statlat(i),strmid(tree(i),0,2),align=0.5
  endfor
endelse
;
; Overlay regions
;
map_plots,[-15.,-15.],[90.,35.],thick=3
map_plots,[61.,61.],[90.,60.],thick=3
map_plots,[128.,128.],[90.,60.],thick=3
map_plots,[-170.,-170.],[90.,50.],thick=3
map_plots,[-125.,-125.],[90.,60.],thick=3
map_plots,[-45.,-45.],[90.,40.],thick=3
map_plots,[30.,30.],[60.,35.],thick=3
map_plots,[115.,115.],[60.,23.],thick=3
map_plots,[60.,60.],[40.,23.],thick=3
map_plots,[-135.,-135.],[50.,30.],thick=3
map_plots,[-100.,-100.],[50.,30.],thick=3
map_plots,[-105.,-105.],[55.,50.],thick=3
map_plots,[-120.,-120.],[60.,55.],thick=3
;
y1=[60.,50.,30.,60.,55.,40.,53.,35.,60.,40.,23.]
x1=[-180.,-170.,-135.,-125.,-120.,-100.,-15.,-15.,30.,30.,60.]
x2=[-170.,-100.,-100.,-120.,-105.,-45.,30.,30.,180.,115.,115.]
for i = 0 , n_elements(y1)-1 do begin
  n=x2(i)-x1(i)+1
  xval=findgen(n)+x1(i)
  yval=replicate(y1(i),n)
  map_plots,xval,yval,thick=3
endfor
;
end
