;
; Plots long chronologies from Taimyr and Tornetraske and Yamal
;
loadct,39
multi_plot,nrow=5,layout='large'
if !d.name eq 'X' then begin
  window,ysize=800,xsize=750,0
  window,ysize=800,xsize=750,1
  !p.font=1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=12
endelse
!y.margin=[0,0]
!y.omargin=[10,4]
!x.omargin=[5,5]
;
levs=[10.,1.5,1.25,1.,0.75,0.5,0.25]
nlev=n_elements(levs)
locol=indgen(nlev)+40
hicol=indgen(nlev)+60
;
def_1color,40,color='deepblue'
def_1color,45,color='lblue'
def_smearcolor,fromto=[40,45]
def_1color,46,color='lgreen'
;
def_1color,60,color='purple'
def_1color,62,color='red'
def_smearcolor,fromto=[60,62]
def_1color,64,color='orange'
def_smearcolor,fromto=[62,64]
def_1color,66,color='yellow'
def_smearcolor,fromto=[64,66]
;
mtit=['Tornetrask','Yamal','Taimyr']
fn=['tornad.rcs','yamal.rcs','taimyr2.rcs']
nts=n_elements(fn)
allnyr=2000
allyear=findgen(allnyr)
allts=fltarr(nts,allnyr)
;
for jjj=0,1 do begin
  case jjj of
    0: begin
      xr=[0,2000]
      yr=[-2.5,3]
      yloc=2.2
    end
    1: begin
      xr=[500,600]
      yr=[-3.6,2.5]
      yloc=1.6
    end
  endcase
  if !d.name eq 'X' then wset,jjj
;
; Repeat for each series
;
for i = 0 , nts-1 do begin
  ;
  ; First read in the appropriate data
  ;
  yrsten=intarr(2)
  openr,1,'/cru/u2/f055/tree6/'+fn(i)
  readf,1,yrsten,format='(6X,2I4)'
  y1=yrsten(0) & adj1=(y1 mod 10) & y1=y1-adj1
  y2=yrsten(1) & adj2=9-(y2 mod 10) & y2=y2+adj2
  print,fn(i),yrsten,y1,y2
  nyr=y2-y1+1
  rawdat=fltarr(2,nyr)
  onedat=fltarr(2,10)
  for j = 0 , nyr-1 , 10 do begin
    readf,1,onedat,format='(10X,10(I4,I3))'
    rawdat(*,j:j+9)=onedat(*,*)
  endfor
  close,1
  ;
  ; Now sort out the missing data
  ;
  timey=findgen(nyr)+y1
  ts=reform(rawdat(0,*))
  ml=where(ts eq 9990,nmiss)
  if nmiss gt 0 then ts(ml)=!values.f_nan
  ;
  ; Now normalise relative to their entire length, and then filter
  ;
  mknormal,ts
  filter_cru,10.,/nan,tsin=ts,tslow=tslow
  if jjj eq 1 then tslow=ts
  ;
  ; Now accumulate the average series
  ;
  if total(abs(allyear-timey)) ne 0 then message,'Ooops!'
  allts(i,*)=ts(*)
  ;
  ; Now plot them
  ;
  pause
  plot,timey,tslow,/nodata,$
    xstyle=1,xrange=xr,xtickformat='nolabels',$
    /ystyle,ytitle='Normalised anomaly',yrange=yr
  xyouts,0.5*total(!x.crange),yloc,align=0.5,mtit(i)
  if i eq 0 then axis,xaxis=1,xstyle=1,xtitle='Year (AD)'
  if i eq 2 then axis,xaxis=0,xstyle=1,xtitle='Year (AD)'
  for j = 0 , nlev-1 do begin
    yyy=tslow
    ymax=levs(j)
    ymin=-ymax
    yyy=(yyy < ymax) > ymin
    cpl_barts,timey,yyy,/overplot,bar_color=[hicol(j),locol(j)],$
      noclip=0
  endfor
  if jjj eq 0 then oplot,timey,tslow $
              else cpl_barts,timey,tslow,/overplot,/outline,noclip=0
  plots,536,1,psym=def_sym(12),symsize=2.5
  oplot,!x.crange,[0.,0.]
  ;
endfor
;
; Now plot their average
;
!p.multi(0)=1
ts=total(allts,1)/float(nts)
mknormal,ts
filter_cru,10.,/nan,tsin=ts,tslow=tslow
if jjj eq 1 then tslow=ts
plot,timey,tslow,/nodata,$
  xstyle=1,xrange=xr,xtickformat='nolabels',$
  /ystyle,ytitle='Normalised anomaly',yrange=yr
xyouts,0.5*total(!x.crange),yloc,align=0.5,'Average series'
axis,xaxis=1,xstyle=1,xtitle='Year (AD)'
axis,xaxis=0,xstyle=1,xtitle='Year (AD)'
for j = 0 , nlev-1 do begin
  yyy=tslow
  ymax=levs(j)
  ymin=-ymax
  yyy=(yyy < ymax) > ymin
  cpl_barts,timey,yyy,/overplot,bar_color=[hicol(j),locol(j)],$
    noclip=0
endfor
if jjj eq 0 then oplot,timey,tslow $
            else cpl_barts,timey,tslow,/overplot,/outline,noclip=0
plots,536,1,psym=def_sym(12),symsize=2.5
oplot,!x.crange,[0.,0.]
;
; Now output the average
;
openw,1,'tornyamataim.ave'
kkk=where(finite(ts),nkkk)
printf,1,nkkk
for i = 0 , nkkk-1 do printf,1,allyear(kkk(i)),ts(kkk(i)),format='(I4,F10.2)'
close,1
;
;multi_plot,nrow=1,/landscape,layout='centred'
;if !d.name eq 'PS' then device,/helvetica,/bold,font_size=12
;;
;plot,timey,tslow,thick=2,$
;  xstyle=1,xrange=[0,2000],xtitle='Year (AD)',$
;  /ystyle,ytitle='Normalised anomaly',yrange=[-3,3]
;oplot,!x.crange,[0.,0.],linestyle=1
;
endfor
;
end
