;
; Plots (1 at a time) yearly maps of calibrated (PCR-infilled or not) MXD
; reconstructions
; of growing season temperatures.  Uses "corrected" MXD - but shouldn't usually
; plot past 1960 because these will be artificially adjusted to look closer to
; the real temperatures.
; Does one map at a time, of size 5cm by 5cm, and stores them in individual
; postscript files for putting round the border of the poster.
;
yrst=1804
doinfill=1
domaps=1
;
; Now prepare for plotting
;
;
; Define map parameters
;
map=def_map(/npolar) & map.limit(0)=25 & map.xmargin=[0,0] & map.ymargin=[0,0]
labels=def_labels(/off)
coast=def_coast(/get_device) & coast.thick=[0.5,2.5]
levs=[-100,-2,-1.2,-0.8,-0.4,-0.2,0,0.3,0.6,1,100]
cols=indgen(10)+20
;
; Get the calibrated data
;
if doinfill eq 0 then begin
  restore,'calibmxd5.idlsave'
  ; Gets: g,mxdyear,mxdnyr,fdcalibu,fdcalibc,mxdfd2,timey,fdseas
endif else begin
  restore,'calibmxd5_pcr.idlsave'
  ; Gets: g,mxdyear,mxdnyr,fdcalibc,timey,fdseas
endelse
;
if domaps ne 0 then begin
yrst=yrst-mxdyear(0)
for iyr = yrst, yrst+23 do begin
  fd=reform(fdcalibc(*,*,iyr))
  ;
  ploton,1
;
loadct,39
multi_plot,nrow=1,layout='centred'
if !d.name eq 'X' then begin
  window,ysize=300,xsize=300
  !p.font=-1
  !p.charsize=!p.charsize*1.5
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=11,xsize=5.,ysize=5.
endelse
def_1color,20,color='palepurple'
def_1color,21,color='lpurple'
def_1color,22,color='deepblue'
def_1color,23,color='mlblue'
def_1color,24,color='vlblue'
def_1color,25,color='vvlgreen'
def_1color,26,color='lsand'
def_1color,27,color='orange'
def_1color,28,color='red'
def_1color,29,color='dred'
;
  inter_boxfd,fd,g.x,g.y,$
    coast=coast,map=map,labels=labels,$
    levels=levs,c_colors=cols
  xyouts,-47,28,string(mxdyear(iyr),format='(I4)')
;  lon_polar,map=map,[-135.,-45.,45.,135.]
  ;
  plotoff
  spawn,'mv idl.ps1 idl.ps'
  spawn,'ps2eps idl'
  spawn,'mv idl.eps /cru/u2/f055/diag/posters/medozatree/map'+$
    string(mxdyear(iyr),format='(I4)')+'.eps'
  ;
endfor
endif
;
ploton,1
loadct,39
multi_plot,nrow=1,layout='centred'
if !d.name eq 'X' then begin
  window,ysize=300,xsize=300
  !p.font=-1
  !p.charsize=!p.charsize*1.5
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=11,xsize=9.,ysize=2.
endelse
def_1color,20,color='palepurple'
def_1color,21,color='lpurple'
def_1color,22,color='deepblue'
def_1color,23,color='mlblue'
def_1color,24,color='vlblue'
def_1color,25,color='vvlgreen'
def_1color,26,color='lsand'
def_1color,27,color='orange'
def_1color,28,color='red'
def_1color,29,color='dred'
!x.margin=[0,0]
scale_horiz,levels=levs,c_colors=cols,noextremes=['Below','Above'],$
  title='!Uo!NC wrt 1961-90'
plotoff
spawn,'mv idl.ps1 idl.ps'
spawn,'ps2eps idl'
spawn,'mv idl.eps /cru/u2/f055/diag/posters/medozatree/scale.eps'
;
end
