pro maps15,yrstart,doinfill=doinfill
;
; Plots 24 yearly maps of calibrated (PCR-infilled or not) MXD reconstructions
; of growing season temperatures.  Uses "corrected" MXD - but shouldn't usually
; plot past 1960 because these will be artificially adjusted to look closer to
; the real temperatures.
;
if n_elements(yrstart) eq 0 then yrstart=1800
if n_elements(doinfill) eq 0 then doinfill=0
if yrstart gt 1937 then message,'Plotting into the decline period!'
;
; Now prepare for plotting
;
loadct,39
multi_plot,nrow=5,ncol=3,layout='large'
if !d.name eq 'X' then begin
  window,ysize=800
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=11
endelse
def_1color,20,color='palepurple'
def_1color,21,color='lpurple'
def_1color,22,color='deepblue'
def_1color,23,color='mlblue'
def_1color,24,color='vlblue'
def_1color,25,color='vvlgreen'
def_1color,26,color='lsand'
def_1color,27,color='orange'
def_1color,28,color='red'
def_1color,29,color='dred'
;
xspan=0.333
yspan=0.23
yover=0.05
ykey=0.06
;
; Define map parameters
;
map=def_map(/npolar) & map.limit(0)=25 & map.xmargin=[0,0] & map.ymargin=[0,0]
labels=def_labels(/off)
coast=def_coast(/get_device) & coast.thick=[0.5,2.5]
levs=[-100,-2,-1.2,-0.8,-0.4,-0.2,0,0.3,0.6,1,100]
cols=indgen(10)+20
xang=findgen(361)*!dtor
xcir=sin(xang)
ycir=cos(xang)
;
; Get the calibrated data
;
if doinfill eq 0 then begin
  restore,'calibmxd5.idlsave'
  ; Gets: g,mxdyear,mxdnyr,fdcalibu,fdcalibc,mxdfd2,timey,fdseas
endif else begin
  restore,'calibmxd5_pcr.idlsave'
  ; Gets: g,mxdyear,mxdnyr,fdcalibc,timey,fdseas
endelse
;
ist=where(mxdyear eq yrstart)
ist=ist(0)
;
for i = 14 , 0 , -1 do begin
  ;
  iyr=i+ist
  fd=reform(fdcalibc(*,*,iyr))
  ;
  ix=i mod 3
  iy=4-(i/3)
  ;
  ix=ix*xspan
  iy=ykey+iy*(yspan-yover)
  !p.position=[ix,iy,ix+xspan,iy+yspan]
  ;
  !p.multi(0)=1
  plot,[-1,1],[-1,1],/nodata,xstyle=5,ystyle=5,xmargin=[0,0],ymargin=[0,0]
  polyfill,xcir,ycir,color=!p.background
  !p.multi(0)=1
  inter_boxfd,fd,g.x,g.y,$
    coast=coast,map=map,labels=labels,$
    levels=levs,c_colors=cols
  xyouts,-47,28,string(mxdyear(iyr),format='(I4)')
  ;
endfor
;
!p.multi(0)=1
!p.position=[0.3,0.015,0.7,ykey-0.015]
scale_horiz,levels=levs,c_colors=cols,noextremes=['Below','Above'],$
  title='!Uo!NC wrt 1961-90'
;
end
