;
; Plots a map showing location of all MXD chronologoes
; *** NOW REMOVES MXD SERIES WITH POOR CORRELATIONS WITH LOCAL SUMMER TEMP ***
;
cutr=0.22      ; a 'best' series is based on sites with local r >= cutr (0.22)
iseas=18       ; Apr-Sep for MXD
;
; First read in the MXD data
;
restore,filename='../allmxd.idlsave'
;  nchron,idno,idname,location,country,tree,yrstart,yrend,statlat,statlon,$
;  mxd,fraction,timey,nyr
;
; Next read in the correlations between MXD and local climate
;
restore,filename='../mxd_moncorr.idlsave'
;  allr,ncorr,nvar,nchron,varname,corrname,statlat,statlon,allp,moir,moir2
;
; Remove any that are almost entirely missing, or that
; aren't well correlated with their local summer temperature
;
nkeep=0
for i = 0 , nchron-1 do begin
  if allr(i,iseas,1) ge cutr then begin
    dummy=where(finite(mxd(*,i)),ngot)
    if ngot ge 20 then begin
      if nkeep eq 0 then kl=i else kl=[kl,i]
      nkeep=nkeep+1
    endif
  endif
endfor
print,'Had',nchron,' chronologies, but',nchron-nkeep,' are empty or poor'
nstat=nkeep
density=mxd(*,kl)
weight=fraction(*,kl)
statlon=statlon(kl)
statlat=statlat(kl)
statcty=country(kl)
;
loadct,39
def_1color,20,color='vlgrey'
multi_plot,nrow=1
if !d.name eq 'X' then begin
  window,xsize=700,ysize=700
  !p.font=-1
endif else begin
  !p.font=0
  device,/helvetica,/bold,font_size=16
endelse
;
map=def_map(/npolar)  &  map.limit(0)=25.
coast=def_coast(/off)
labels=def_labels(/off)
;
inter_boxfd,/nodata,map=map,coast=coast,labels=labels
;  title='Location of tree-ring density chronologies'
map_continents,/coasts,/fill_continents,color=20
map_continents,/coasts
map_continents,/countries,mlinestyle=1,mlinethick=0.5
map_plots,findgen(361)-180.,replicate(25.,361)
;
cpl_usersym,/circle,/fill
plots,statlon,statlat,psym=8,symsize=0.7
cpl_usersym,/circle
plots,statlon,statlat,psym=8,symsize=0.7,color=!p.background
;
end
