;
; Computes correlations on full, high and low pass timeseries of density
; anomalies, ring width anomalies and instrumental anomalies.
;
restore,filename='reglists.idlsave'
;
; Read in timeseries and compute correlations
;
perst=1881.
peren=1960.
;
openw,1,'corr_all2all.out'
thalf=10.
printf,1,'Correlations between timeseries'
printf,1,'              density vs. width  density vs. instru    width vs. instru'
printf,1,'     Region    Full  High   Low    Full  High   Low    Full  High   Low'
;
iregname=['ALL',regname]
regname=['MEAN',regname]
nreg=nreg+1
for i = 0 , nreg-1 do begin
  print,i
  ;
  restore,filename='densadj_'+regname(i)+'.idlsave'
  y1=densadj
  filter_cru,thalf,tsin=y1,tslow=ylow1,tshigh=yhi1,/nan
  ;
  restore,filename='instradj_'+iregname(i)+'.idlsave'
  y3=instradj
  filter_cru,thalf,tsin=y3,tslow=ylow3,tshigh=yhi3,/nan
  ;
  keeplist=where(finite(y1+y3) and (x ge perst) and (x le peren),nkeep)
  ts1=y1(keeplist)
  ts2=y3(keeplist)
  r4=correlate(ts1,ts2)
  ;
  print,i,a_correlate(ts1,[-1]),a_correlate(ts2,[-1])
  ;
  ts1=yhi1(keeplist)
  ts2=yhi3(keeplist)
  r5=correlate(ts1,ts2)
  ;
  ts1=ylow1(keeplist)
  ts2=ylow3(keeplist)
  r6=correlate(ts1,ts2)
  ;
  r1=!values.f_nan
  r2=r1 & r3=r1 & r7=r1 & r8=r1 & r9=r1
  printf,1,regname(i),r1,r2,r3,r4,r5,r6,r7,r8,r9,$
      format='(A11,3(2X,3F6.2))'
  ;
endfor
;
printf,1,' '
printf,1,'Correlations carried out over the period ',perst,peren
printf,1,' '
printf,1,'To separate low and high frequency components, a gaussian weighted'
printf,1,'filter was used with a half-width (years) of ',thalf
;
close,1
;
end
