;
; Plots mean timeseries of density anomaly, no. of contributing chronologies
; and fraction of cores available
;
multi_plot,nrow=2
if !d.name eq 'X' then begin
  window,ysize=900
endif else begin
  device,xoffset=2,xsize=17
endelse
;
ncid=ncdf_open('tree_dens_nh.nc')
ncdf_diminq,ncid,'time',dummy,ntime
ncdf_diminq,ncid,'station',dummy,nstat
ncdf_varget,ncid,'year',x
ncdf_varget,ncid,'density',density
ncdf_attget,ncid,'density','missing_value',valmiss
ncdf_varget,ncid,'fraction',weight
ncdf_close,ncid
;
misslist=where(density eq valmiss,nmiss)
density(misslist)=!values.f_nan
;
restore,filename='reglists.idlsave'
;
yrange=[0.,350.]
xrange=[1600.,2000.]
plot,[0,1],/nodata,title='Number of contributing chronologies',$
    xtitle='Year',$
    yrange=yrange,/ystyle,$
    xrange=xrange,/xstyle
;
basel=x*0.
for i = 0 , nreg-1 do begin
  dens=density(*,treelist(0:ntree(i)-1,i))
  mchron=total(finite(dens),2)
  regx=[reverse(x),x]  &  regy=[reverse(basel),basel+mchron]
  polyfill,regx,regy,spacing=0.25,orientation=60.*i
  oplot,x,basel+mchron,thick=3
  basel=basel+mchron
  xloc=[1900,1930,1930,1900]
  yloc=-[1,1,20,20]+max(basel,/nan)
  polyfill,xloc,yloc,color=!p.background
  xyouts,xloc(0)+5,yloc(2)+5,regname(i)
endfor
;
end
