pro mknormal,data,t,refperiod=refperiod,refmean=refmean,refsd=refsd
;
; Normalises array of data (space,time) over the period given by the
; refperiod=[a,b] period (which is in t units if t is present, else it is in
; element numbers.
;
;-----------------------------------------------------------------------
;
; Get data dimensions
;
dsize=size(data)
case dsize(0) of
  1: begin
    nx=1
    nt=dsize(1)
    data=reform(data,nx,nt)
  end
  2: begin
    nx=dsize(1)
    nt=dsize(2)
  end
  else: message,'data must be a 1D (time) or 2D (space,time) array'
endcase
;
; Create or check time values
;
if n_params() eq 1 then begin
  t=findgen(nt)
endif else begin
  tsize=size(t)
  if tsize(0) ne 1 then message,'t must be a 1D (time) array'
  if tsize(1) ne nt then message,'data and t are incompatible sizes'
endelse
;
; Now compute mean and standard deviation over the reference period
;
refsd=fltarr(nx)
refmean=fltarr(nx)
if n_elements(refperiod) ne 2 then $
  message,'refperiod must be a 2-element [start,end] vector'
startel=where(t eq refperiod(0),n)
if n ne 1 then message,'Cannot find the reference start time in the t vector'
endel=where(t eq refperiod(1),n)
if n ne 1 then message,'Cannot find the reference end time in the t vector'
;print,startel,endel
for ix = 0 , nx-1 do begin
  x=data(ix,startel(0):endel(0))
  keeplist=where(finite(x),nkeep)
  print,'Ref. period length=',nkeep
  if nkeep lt 5 then message,'Less than 5 values will not give an accurate s.d.'
  xmom=moment(x(keeplist),sdev=xsd)
  refmean(ix)=xmom(0)
  refsd(ix)=xsd
  data(ix,*) = ( data(ix,*)-refmean(ix) ) / refsd(ix)
endfor
;
data=reform(data)
;
end
