;
; Computes lists of grid-boxes in each region
;
;----------------------------------------------------
;
; Get chronology locations
;
ncid=ncdf_open('tree_dens_su1400.nc')
ncdf_varget,ncid,'longitude',xlon
ncdf_varget,ncid,'latitude',ylat
ncdf_close,ncid
;
; Get region info
;
restore,'reglists.idlsave'
;
; Get IPCC instrumental dataset grid
;
g=def_grid(/ipcc)
;
; For each region, locate the grid-boxes with data in
;
boxlists=fltarr(g.nx,g.ny,nreg)*!values.f_nan
boxnumbs=fltarr(g.nx,g.ny,nreg)
for ireg = 0 , nreg-1 do begin
  toplat=72.5
  leftlon=32.5+ireg*10.
  topele=where(g.y eq toplat)
  leftele=where(g.x eq leftlon)
  ite=topele(0)
  ile=leftele(0)
  boxlists(ile:ile+1,ite:ite+2,ireg)=1.
  statx=xlon(treelist(0:ntree(ireg)-1,ireg))
  staty=ylat(treelist(0:ntree(ireg)-1,ireg))
  statval=fltarr(ntree(ireg))+1.
  fdout=gridit(g.nx,g.ny,g.x,g.y,statx,staty,statval,nstat=nstat)
  boxnumbs(*,*,ireg)=nstat(*,*)
endfor
;
save,filename='regboxes.idlsave',nreg,boxlists,boxnumbs,regname
;
end
