;
; Plots mean timeseries of instrumental data
;
plot,[0,1]
multi_plot,nrow=4
loadct,39
def_1color,r,g,b,1,color='red'
def_1color,r,g,b,2,color='blue'
if !d.name eq 'X' then begin
  window,ysize=900
endif else begin
  device,xoffset=2,xsize=17
endelse
;
; Get region info and rbar for each region
;
restore,filename='regboxes.idlsave'
restore,filename='rbar_instr_full.idlsave'
for ireg = 0 , nreg-1 do begin
  restore,filename='nc.instrts_'+regname(ireg)+'.idlsave'
  totval=total(winstr(*,3:8),2,/nan)
  totn=total(finite(winstr(*,3:8)),2)
  keeplist=where(totn gt 0,nkeep)
  wdens=totval*!values.f_nan
  wdens(keeplist)=totval(keeplist)/float(totn(keeplist))
  totcover=total(wcover(*,3:8),2)/6.      ; compute mean no. of boxes with data
  ;
  ; Need to adjust for varying sample size
  ;
  xadj=mkeffective(wdens,totcover,rbar=allrbar(ireg),neff=neff)
  wdens=xadj
;
; Now normalise w.r.t. 1901-1940
;
help,wdens
  mknormal,wdens,x,refperiod=[1901,1940],refmean=refmean,refsd=refsd
help,wdens
print,refmean,refsd
;
  pause
  filter_cru,20,tsin=wdens,tslow=tslow,/nan
  cpl_barts,x,wdens,$
    title='Normalised instrumental temperature anomaly (Apr-Sep)'+$
      ' for region: '+regname(ireg),xtitle='Year',/xstyle,$
    yrange=[-4,4],noclip=0,ytitle='Normalised temperature',$
    zeroline=tslow        ;,bar_color=[1,2]
  oplot,x,tslow,thick=2
  moms=moment(wdens(where(finite(wdens))),sdev=sdev)
  oplot,!x.crange,[moms(0),moms(0)]
  oplot,!x.crange,[moms(0)+sdev,moms(0)+sdev],linestyle=1
  oplot,!x.crange,[moms(0)-sdev,moms(0)-sdev],linestyle=1
  ;
  plot,x,totcover,linestyle=1
  oplot,x,neff,thick=3
  ;
  instradj=wdens
  save,filename='instradj_'+regname(ireg)+'.idlsave', $
    x,instradj,totcover
  ;
endfor
;
end
