pro plot_record,rawdat,yrange=yrange,labels=labels,$
  cols=cols,ygap=ygap,_extra=e
;
datsize=size(rawdat)
if datsize(0) ne 2 then message,'requires 2D array: mxd/trw, month/season'
nxd=datsize(2)
;
plot,[0.,0.],/nodata,_extra=e,$
  yrange=yrange,ystyle=1,xrange=[0.,nxd+1.],xstyle=5,$
  ymargin=[1.,2.]
;
if n_elements(ygap) eq 0 then ygap=0.1
nline=(yrange(1)-yrange(0))/ygap + 1
for i = 0 , nline-1 do begin
  ylev=yrange(0)+ygap*float(i)
  if abs(ylev) gt 0.11 then $
    plots,[0.,nxd+1.],[ylev,ylev],linestyle=1,thick=0.5
endfor
;
uplist=strarr(nxd)
dnlist=strarr(nxd)
uplist(*)=' '
dnlist(*)=' '
for i = 0 , nxd-1 do begin
  for j = 0 , 1 do begin
    yt=rawdat(j,i)
    xl=float(i+1)+float(j-1)*0.4
    xr=xl+0.4
    if finite(yt) then begin
      polyfill,[xl,xr,xr,xl,xl],[0.,0.,yt,yt,0.],color=cols(j)
      if j eq 0 then begin
        if yt lt 0. then uplist(i)=labels(i) else dnlist(i)=labels(i)
      endif
    endif
  endfor
endfor
;
axis,0.,/xaxis,xstyle=1,xrange=[0.,nxd+1.],xticks=nxd-1,$
  xtickv=findgen(nxd)+0.8,$
  xtickname=uplist
axis,0.,xaxis=0,xstyle=1,xrange=[0.,nxd+1.],xticks=nxd-1,$
  xtickv=findgen(nxd)+0.8,$
  xtickname=dnlist
;
return
end
