;
g=def_grid(/ipcc)
;
multi_plot,nrow=1,layout='centred'
if !d.name eq 'X' then begin
  window,xsize=650,ysize=950
endif
loadct,0
def_1color,r,gr,b,100,color='lgrey'
;
map=def_map(/npolar)  &  map.limit(0)=30.
coast=def_coast(/get_device)  &  coast.double=0
labels=def_labels(/off)
;
restore,filename='regboxes.idlsave'
iall=where(regname eq 'ALL')
i=iall(0)
;
fd1=boxlists(*,*,i)
dummy=where(finite(fd1),nboxxx)
inter_boxfd,fd1,g.x,g.y,map=map,coast=coast,labels=labels,$
  levels=[0.5,1.5],c_colors=[100]
;
x1=[180.,131.,75.,38.,-40.,-99.]
y1=[30.,30.,30.,30.,30.,30.]
x2=[180.,131.,75.,38.,-40.,-99.]
y2=[90.,90.,90.,90.,90.,90.]
n=n_elements(x1)
for i = 0 , n-1 do begin
  map_plots,[x1(i),x2(i)],[y1(i),y2(i)],thick=6
endfor
;
xs=findgen(79)-40.
ys=replicate(50.,79)
map_plots,xs,ys,thick=6
;
xs=findgen(82)-180.
ys=replicate(56.,82)
map_plots,xs,ys,thick=6
;
; Plots maps of chronology location
;
ncid=ncdf_open('tree_dens_nh.nc')
ncdf_diminq,ncid,'station',dummy,nstat
ncdf_varget,ncid,'country',country
ncdf_varget,ncid,'tree',tree
ncdf_varget,ncid,'latitude',ylat
ncdf_varget,ncid,'longitude',xlon
ncdf_close,ncid
;
restore,filename='reglists.idlsave'
;
i=iall(0)
x=xlon(treelist(0:ntree(i)-1,i))
y=ylat(treelist(0:ntree(i)-1,i))
cpl_usersym,/circle,/fill
plots,x,y,psym=8,color=!p.background,symsize=1.15,noclip=0
cpl_usersym,/circle
plots,x,y,psym=8,thick=1,symsize=1.15,noclip=0
;
end
