pro bentline,x,a,f,pder
;
; returns the value of a function, f, for a given set of x values and a given
; parameter set, a.  The function is two straight lines, meeting at x=0.
; For x<=0, f(x)=a+bx.  For x>=0, f(x)=a+cx.    here, a=[a,b,c]
;
f=x
neglist=where(x le 0.,nneg)
if nneg gt 0 then f(neglist)=a(0)+a(1)*x(neglist)
poslist=where(x gt 0.,npos)
if npos gt 0 then f(poslist)=a(0)+a(2)*x(poslist)
;
if n_params() ge 4 then begin
  pder=[ [x*0.+1.] , [x*0.] , [x*0.] ]
  pder(neglist,1)=x(neglist)
  pder(poslist,2)=x(poslist)
endif
;
end
