;
; Plots maps of chronology location
;
loadct,39
def_1color,50,color='mdgrey'
def_1color,51,color='red'
multi_plot,nrow=4,ncol=3,layout='large'
if !d.name eq 'X' then begin
  window,xsize=650,ysize=950
endif
;
map=def_map(/npolar)  &  map.limit(0)=30.
coast=def_coast(/off)
labels=def_labels(/off)
;
nreg=10
regname=strarr(nreg)
maxtree=330
ntree=fltarr(nreg)
xlon=fltarr(maxtree,nreg)
ylat=fltarr(maxtree,nreg)
;
openr,1,'arealist.dat'
headst=' '
for i = 0 , nreg-1 do begin
  if i ne nreg-1 then begin      ; do final region (ALL) separately
    readf,1,headst
    regname(i)=headst
    ist=strpos(headst,'(')+1
    ilen=strpos(headst,')')-ist
    n=fix(strmid(headst,ist,ilen))
    rawdat=fltarr(2,n)
    readf,1,rawdat,format='(I5,1X,I6)'
    rawdat=rawdat/100.
    ntree(i)=n
    ylat(0:n-1,i)=rawdat(0,*)
    xlon(0:n-1,i)=rawdat(1,*)
    ylat(ntree(nreg-1):ntree(nreg-1)+n-1,nreg-1)=rawdat(0,*)
    xlon(ntree(nreg-1):ntree(nreg-1)+n-1,nreg-1)=rawdat(1,*)
    ntree(nreg-1)=ntree(nreg-1)+n
  endif else begin
    ; add 2 extra sites only included in 'all'
    n=2
    ylat(ntree(nreg-1):ntree(nreg-1)+n-1,nreg-1)=[50.95,54.88]
    xlon(ntree(nreg-1):ntree(nreg-1)+n-1,nreg-1)=[-1.68,58.88]
    ntree(nreg-1)=ntree(nreg-1)+n
    regname(i)='all('+string(ntree(i),format='(I3)')+')'
  endelse
  ;
  inter_boxfd,/nodata,map=map,coast=coast,labels=labels,$
    title=regname(i)
  map_continents,/coasts,color=50,mlinethick=0.5
  map_continents,/countries,color=50,mlinestyle=1,mlinethick=0.5
  ;
  x=xlon(0:ntree(i)-1,i)
  y=ylat(0:ntree(i)-1,i)
  cpl_usersym,/circle,/fill
  plots,x,y,psym=8,color=51,symsize=0.5
  cpl_usersym,/circle
  plots,x,y,psym=8,thick=2,symsize=0.5
  ;
endfor
close,1
;
save,filename='reglists.idlsave',maxtree,ntree,nreg,regname,$
  xlon,ylat
;
end
