! maskpolestim.f90
! f90 main program written on 03.03.00 by Tim Mitchell
! last modification on 03.03.00
! f90 -o maskpolestim initialmod.f90 loadmod.f90 savemod.f90 maskpolestim.f90

program MaskPolesTim

use InitialMod
use LoadMod
use SaveMod

implicit none

real, pointer, dimension (:,:)		:: ThisTim

integer, pointer, dimension (:) 	:: WorkMapRawReg, WorkRegSizes, WorkADYear
integer, pointer, dimension (:,:) 	:: WorkMapIDLRaw, WorkMapIDLReg

character (len=80), pointer, dimension (:)	:: FileLinNames
character (len=20), pointer, dimension (:) 	:: WorkRegNames

real, parameter :: MissVal = -999.0

integer :: WorkGrid, WorkLongN, WorkLatN, WorkDataN
integer :: WorkRegN, WorkTimN
integer :: WorkMonth0,WorkMonth1,WorkMonthN,WorkYearN,WorkDecN
integer :: AllocStat, ReadStatus
integer :: TimFileN, XTimFile, XLong, XReg, FileLinN

character (len=10) :: WorkGridTitle
character (len=40) :: WorkRegTitle
character (len=80) :: WorkGridFilePath, WorkTimTitle, Blank

!*******************************************************************************
! main loop

Blank = ""

print*, "  > ***** MaskPolesTim *****"
print*

call GridSelect   (WorkGrid,WorkGridTitle,WorkLongN,WorkLatN,WorkDataN,WorkGridFilePath)
call PeriodSelect (WorkYearN,WorkDecN,WorkADYear)
call RegSelect    (WorkGrid,WorkLongN,WorkLatN,WorkDataN,WorkMapIDLReg,WorkRegSizes,WorkRegNames,&
		   WorkRegTitle,WorkRegN)

print*, "  > Select the number of .tim files with poles to be masked out: "
do
	read (*,*,iostat=ReadStatus), TimFileN
	if (ReadStatus.LE.0.AND.TimFileN.GE.1) exit
end do

do XTimFile = 1, TimFileN
  print*, "  > File number: ", XTimFile
  
  do
    call LoadTim (WorkYearN,WorkADYear,FileLinN,FileLinNames,ThisTim)
    if (FileLinN.NE.WorkRegN) then
    	print*, "  > Wrong number of regions. Try again."
    	deallocate (FileLinNames,ThisTim)
    end if
    if (FileLinN.EQ.WorkRegN) exit
  end do  
  
  do XLong = 1, WorkLongN
    XReg = WorkMapIDLReg (XLong,1)
    ThisTim (XReg,1:WorkYearN) = MissVal
    XReg = WorkMapIDLReg (XLong,WorkLatN)
    ThisTim (XReg,1:WorkYearN) = MissVal
  end do
  
  call SaveTim (WorkRegN,WorkYearN,Blank,Blank,FileLinNames,WorkADYear,ThisTim)  
end do

deallocate (ThisTim,FileLinNames)
deallocate (WorkMapIDLReg,WorkRegSizes,WorkRegNames)

print*

end program MaskPolesTim
