pro WeedBlanks, ModelLongN, ModelLatN, Grey, SelArray, RegSize, RegName, RegColour, NextFree

MissVal   = -999.0
ModelBoxN = 0L
ModelBoxN = ModelLongN * ModelLatN

OpArray       = lonarr (ModelLongN, ModelLatN)
OpArray [*,*] = MissVal
OpSize        = lonarr (ModelBoxN)
OpSize [*]    = 0
OpName        = strarr (ModelBoxN)
OpName [*]    = ""
OpColour      = intarr (ModelBoxN)
OpColour [*]  = Grey

Transform     = lonarr (ModelBoxN)
Transform [*] = MissVal

NextFree = 0L
for XReg = 0L, (ModelBoxN-1) do begin
  if (RegName(XReg) NE "" AND RegSize(XReg) GT 0) then begin
  	Transform [XReg] = NextFree
  	
  	OpSize   [NextFree] = RegSize   [XReg]
  	OpName   [NextFree] = RegName   [XReg]
  	OpColour [NextFree] = RegColour [XReg]
        
  	NextFree = NextFree + 1
  endif
endfor

;LogFilePath = '/cru/u2/f709762/data/scratch/log-idl.dat'		; #########
;openw, lunLog, LogFilePath, /get_lun, error=OpenStatus

TotValid = 0L
for XLong = 0, (ModelLongN-1) do begin
  for XLat = 0, (ModelLatN-1) do begin
;    printf, lunLog, XLong, XLat, SelArray[XLong,XLat], format='(2i6,i8)'

    if (SelArray[XLong,XLat] NE MissVal) then begin
    	OpArray [XLong,XLat] = Transform ( SelArray[XLong,XLat] )
    	TotValid             = TotValid + 1
    endif
  endfor
endfor

;free_lun, lunLog			; ############

SelArray  [*,*] = OpArray   [*,*]
RegSize   [*]   = OpSize    [*]
RegName   [*]   = OpName    [*]
RegColour [*]   = OpColour  [*]

print, "  > Regions and valid boxes found: ", NextFree, TotValid, format='(a35,i8,i8)'

end
