; feed this routine with the filepath and file info line
; it will find the Period, if it is there to be found
; it will also return the century to which the period belongs

pro SearchPeri, FilePath, FileInfo, PeriName, Century

PeriName = "missing"
StringN = 9 & FoundN = 0 & Century = -999.0

SearchStr = strarr (StringN,6)
SearchStr (0,*) = ['20th','1900-1999','1901-2000','1900-99','1901-00','c20'] 
SearchStr (1,*) = ['1910s','1915','1900-1929','1901-1930','1900-29','1901-30'] 
SearchStr (2,*) = ['1940s','1945','1930-1959','1931-1960','1930-59','1931-60'] 
SearchStr (3,*) = ['1970s','1975','1960-1989','1961-1990','1960-89','1961-90'] 
SearchStr (4,*) = ['21st','2000-2099','2001-2100','2000-99','2001-00','c21'] 
SearchStr (5,*) = ['2020s','2025','2010-2039','2011-2040','2010-39','2011-40'] 
SearchStr (6,*) = ['2050s','2055','2040-2069','2041-2070','2040-69','2041-70'] 
SearchStr (7,*) = ['2080s','2085','2070-2099','2071-2100','2070-99','2071-00'] 
SearchStr (8,*) = ['full','1860-2099','400y','1860-2099','1860-3249','1860-3259'] 

PeriStr = strarr (StringN)     
PeriStr = ['20th','1910s','1940s','1970s','21st','2020s','2050s','2080s','full'] 

Text = strarr (2)
Text[1] = FilePath & Text[0] = FileInfo

for XText = 0, 1 do begin            
 if (FoundN EQ 0) then begin
  for XSearch = 0, (StringN-1) do begin
    for XInstance = 0, 5 do begin
      if (strpos(Text[XText],SearchStr[XSearch,XInstance]) NE -1) then begin
    	PeriName = PeriStr(XSearch)
    	FoundN = FoundN + 1
    	if (XSearch LE 3) then Century = 20
    	if (XSearch GT 3) then Century = 21
      endif
    endfor
  endfor
 endif
endfor

if (FoundN NE 1) then begin
  PeriName = "missing"
  
  InputInt = -1 
  while (PeriName EQ "missing") do begin
   print, "  > Identify the period (-1=list): "
   read, InputInt
    
   if (InputInt EQ -1) then begin
     for XString = 0, (StringN-1) do begin
       print, "  > ", XString, " : ", PeriStr(XString), format='(a4,i2,a3,a)'
     endfor
   endif else begin
     if (InputInt LT 0 OR InputInt GT (StringN-1)) then begin
       print, "  > Try again."
     endif else begin
       PeriName = PeriStr (InputInt)
       if (InputInt LE 3) then Century = 20
       if (InputInt GT 3) then Century = 21
     endelse
   endelse
  endwhile
endif

end
