; savegraphspec.pro
; program that saves a graph specification file for plotanalysis.pro or plotlins.pro
; written by Tim Mitchell on 07.02.01
; last modified on 07.02.01

;*******************************************************************************

pro SaveGraphSpec, DimGraph,PlotOpt,GraphOpt,GraphNames

SpecFilePath = "" & OpenStatus = -1 & SpecTitle=""

Datum0=0.0D & 	Datum1=0.0D &	Datum2=0.0D &	Datum3=0.0D
Datum4=0.0D & 	Datum5=0.0D &	Datum6=0.0D & 	Datum7=0.0D

print, "  > Enter the filepath of the .spec file: "
while (OpenStatus NE 0) do begin
  read, SpecFilePath
  SpecFilePath = strtrim(SpecFilePath,2)
  openw, lunSpec, SpecFilePath, /get_lun, error=OpenStatus
  if (OpenStatus NE 0) then print, "  > File cannot be opened. Re-enter filepath."
endwhile  

print, "  > Enter the title of the .spec file: "
read, SpecTitle
SpecTitle = strtrim (SpecTitle,2)

printf, lunSpec, SpecTitle,  		format='(a80)'		; title

printf, lunSpec, DimGraph,	 	format='(i4)'		; no. graphs

for XOpt = 0, 2 do begin
  printf, lunSpec, PlotOpt(XOpt),	format='(i4)'		; columns,rows,order	
endfor

for XGraph = 0, (DimGraph-1) do begin
  Datum0 = GraphOpt(XGraph,0) & Datum1 = GraphOpt(XGraph,1)	; type, axis colour
  Datum2 = GraphOpt(XGraph,2) & Datum3 = GraphOpt(XGraph,3)	; axis constraint, x min
  Datum4 = GraphOpt(XGraph,4) & Datum5 = GraphOpt(XGraph,5)	; x max, y min
  Datum6 = GraphOpt(XGraph,6) & Datum7 = GraphOpt(XGraph,7)	; y max, x tick marks

  printf, lunSpec, Datum0,Datum1,Datum2,Datum3,Datum4,Datum5,Datum6,Datum7, format='(8f12.4)'
endfor

for XGraph = 0, (DimGraph-1) do begin
  for XName = 0, 3 do begin
    printf, lunSpec, GraphNames(XGraph,XName), format='(a80)'	; names	
  endfor
endfor

free_lun, lunSpec

end
