; finds .tim file and loads it
; returns all variables in call line

pro LoadTim, RegN, YearN, RegNames, YearAD, TimLoaded

ExitStatus = 0
TimFilePath = "" & 	TimTitle = "" & 	TimFormat = "" & 	CheckFilePath = ""
RegN = 0 & 	YearN = 0 &	YearTenN = 0
MissVal = -999.0
DatumCha = '' &	DatumInt=0

Datum0=0.0 & 	Datum1=0.0 &	Datum2=0.0 &	Datum3=0.0 &	Datum4=0.0 
Datum5=0.0 &	Datum6=0.0 & 	Datum7=0.0 &	Datum8=0.0 & 	Datum9=0.0

print, "  > Enter the filepath of the .tim file: "

while (ExitStatus NE 1) do begin				; initial interrogation
 OpenStatus = -1
 while (OpenStatus NE 0) do begin
  read, TimFilePath
  TimFilePath = strtrim(TimFilePath,2)
  openr, lunTim, TimFilePath, /get_lun, error=OpenStatus
  if (OpenStatus NE 0) then print, "  > File cannot be opened. Re-enter filepath."
 endwhile  

 readf, lunTim, TimTitle,  format='(a80)'			; title
 readf, lunTim, TimFormat, format='(a10)'			; format
 readf, lunTim, RegN, YearN, format='(2i6)'			; dims
 YearTenN = YearN / 10
 
 ExitStatus = 1
endwhile

print, "  > ", strtrim(TimTitle,2)				; print to show success in identifying file

RegNames  = strarr (RegN)
YearAD    = intarr (YearN)
TimLoaded = dblarr (RegN,YearN)					; output arrays
  
for XReg = 0, (RegN-1) do begin
  readf, lunTim, DatumCha, format='(a20)'
  RegNames(XReg) = DatumCha
endfor

for XYear = 0, (YearN-1) do begin
  readf, lunTim, DatumInt, format='(i4)'
  YearAD(XYear) = DatumInt
endfor

for XReg = 0, (RegN-1) do begin
  for XTen = 0, (YearTenN-1) do begin
    readf, lunTim, Datum0,Datum1,Datum2,Datum3,Datum4,Datum5,Datum6,Datum7,Datum8,Datum9, format=TimFormat
    
    TimLoaded (XReg,((XTen*10)+0)) = Datum0
    TimLoaded (XReg,((XTen*10)+1)) = Datum1
    TimLoaded (XReg,((XTen*10)+2)) = Datum2
    TimLoaded (XReg,((XTen*10)+3)) = Datum3
    TimLoaded (XReg,((XTen*10)+4)) = Datum4

    TimLoaded (XReg,((XTen*10)+5)) = Datum5
    TimLoaded (XReg,((XTen*10)+6)) = Datum6
    TimLoaded (XReg,((XTen*10)+7)) = Datum7
    TimLoaded (XReg,((XTen*10)+8)) = Datum8
    TimLoaded (XReg,((XTen*10)+9)) = Datum9
  endfor
endfor

free_lun, lunTim

end
