; may call with either Year0,Year1, or Data, or both

pro LoadPer, CallFile=CallFile,Data=Data,Year0=Year0,Year1=Year1

Trash = "" & LineFormat="" & FileYear0=0 & FileYear1=0 & FileYearAD=0
LineData = fltarr(17)

FilePath="" & ExitStatus=0
if (keyword_set(CallFile)) then FilePath = CallFile

while (ExitStatus NE 1) do begin				; initial interrogation
 OpenStatus = -1
 if (FilePath EQ "") then print, "  > Enter the filepath of the .per file: "
 
 while (OpenStatus NE 0) do begin
    if (FilePath EQ "") then read, FilePath
    FilePath = strtrim(FilePath,2)
    openr, lunPer, FilePath, /get_lun, error=OpenStatus
    if (OpenStatus NE 0) then begin
    	FilePath = ""
    	print, "  > File cannot be opened. Re-enter filepath."
    endif else begin
        ExitStatus=1
        free_lun, lunPer
    endelse
 endwhile  
endwhile

openr, lunPer, FilePath, /get_lun

readf, lunPer, Trash, format='(a80)'
readf, lunPer, Trash, format='(a80)'
readf, lunPer, Trash, FileYear0, Trash, FileYear1, Trash, LineFormat, format='(a9,i4,a1,i4,a36,a20)'
readf, lunPer, Trash, format='(a80)'

NFileYear = FileYear1 - FileYear0 + 1

Data=fltarr(NFileYear,17)
 
for XFileYear = 0, NFileYear-1 do begin
  readf, lunPer, FileYearAD, LineData, format=LineFormat
  Data(XFileYear,*) = LineData(*)
endfor

free_lun, lunPer

Year0=FileYear0
Year1=FileYear1

end
