; interrogates .mon file and loads it

pro LoadMon, CallFile, Data, HeadN,LonN,LatN,ColN,RowN,LineFormat,ShortFormat

MissVal = -999.0 & Trash=""
ShortN=LonN-((RowN-1)*ColN)

Datum0=0.0 & 	Datum1=0.0 &	Datum2=0.0 &	Datum3=0.0
Datum4=0.0 & 	Datum5=0.0 &	Datum6=0.0 & 	Datum7=0.0 & Datum8=0.0 & Datum9=0.0

FilePath=CallFile & OpenStatus=-1
while (OpenStatus NE 0) do begin
    if (FilePath EQ "") then begin
    	print, "  > Enter the filepath of the .mon file: "
    	read, FilePath
    endif
    FilePath = strtrim(FilePath,2)
    openr, lunMon, FilePath, /get_lun, error=OpenStatus
    if (OpenStatus NE 0) then begin
    	FilePath = ""
    	print, "  > File cannot be opened. Re-enter filepath."
    endif
endwhile  

Data=fltarr(12,LonN,LatN) & Data(*,*,*)=MissVal

for XMonth = 0, 11 do begin
 if (HeadN gt 0) then begin
   for XHead = 0, HeadN-1 do begin
     readf,lunMon, Trash, format="(a1)"
   endfor
 endif
 
 for XLat = 0, (LatN-1) do begin
  for XRow = 0, (RowN-2) do begin
    readf,lunMon,Datum0,Datum1,Datum2,Datum3,Datum4,Datum5,Datum6,Datum7,Datum8,Datum9, format=LineFormat
    if (ColN GT  0) then Data(XMonth,(XRow*ColN)+0,XLat)=Datum0
    if (ColN GT  1) then Data(XMonth,(XRow*ColN)+1,XLat)=Datum1
    if (ColN GT  2) then Data(XMonth,(XRow*ColN)+2,XLat)=Datum2
    if (ColN GT  3) then Data(XMonth,(XRow*ColN)+3,XLat)=Datum3
    if (ColN GT  4) then Data(XMonth,(XRow*ColN)+4,XLat)=Datum4
    if (ColN GT  5) then Data(XMonth,(XRow*ColN)+5,XLat)=Datum5
    if (ColN GT  6) then Data(XMonth,(XRow*ColN)+6,XLat)=Datum6
    if (ColN GT  7) then Data(XMonth,(XRow*ColN)+7,XLat)=Datum7
    if (ColN GT  8) then Data(XMonth,(XRow*ColN)+8,XLat)=Datum8
    if (ColN GT  9) then Data(XMonth,(XRow*ColN)+9,XLat)=Datum9
  endfor  
  readf,lunMon, LineData(0:ShortN-1), format=ShortFormat
  Data(XMonth,LonN-ShortN:LonN-1,XLat)=LineData(0:ShortN-1)
 endfor
endfor

free_lun, lunMon

Valid = where (Data ne MissVal, ValidN)
print, "  > Valid data in .mon totals: ", ValidN

end
