; loadgraphspec.pro
; program that loads a graph specification file for plotanalysis.pro or plotlins.pro
; written by Tim Mitchell on 07.02.01
; last modified on 07.02.01

;*******************************************************************************

pro LoadGraphSpec, DimGraph,PlotOpt,GraphOpt,GraphNames

SpecFilePath = "" & OpenStatus = -1 & SpecTitle=""

Datum0=0.0D & 	Datum1=0.0D &	Datum2=0.0D &	Datum3=0.0D
Datum4=0.0D & 	Datum5=0.0D &	Datum6=0.0D & 	Datum7=0.0D

Int=0 & String=""

print, "  > Enter the filepath of the .spec file: "
while (OpenStatus NE 0) do begin
  read, SpecFilePath
  SpecFilePath = strtrim(SpecFilePath,2)
  openr, lunSpec, SpecFilePath, /get_lun, error=OpenStatus
  if (OpenStatus NE 0) then print, "  > File cannot be opened. Re-enter filepath."
endwhile  

readf, lunSpec, SpecTitle,  		format='(a80)'		; title
SpecTitle = strtrim (SpecTitle,2)
print, SpecTitle

readf, lunSpec, DimGraph,	 	format='(i4)'		; no. graphs

PlotOpt    = intarr (3)      
GraphOpt   = dblarr (DimGraph,8)
GraphNames = strarr (DimGraph,4)

for XOpt = 0, 2 do begin
  readf, lunSpec, Int, format='(i4)'		; columns,rows,order	
  PlotOpt(XOpt) = Int
endfor

for XGraph = 0, (DimGraph-1) do begin
  readf, lunSpec, Datum0,Datum1,Datum2,Datum3,Datum4,Datum5,Datum6,Datum7, format='(8f12.4)'
  
  GraphOpt(XGraph,0) = Datum0 & GraphOpt(XGraph,1) = Datum1 	; type, axis colour
  GraphOpt(XGraph,2) = Datum2 & GraphOpt(XGraph,3) = Datum3	; axis constraint, x min
  GraphOpt(XGraph,4) = Datum4 & GraphOpt(XGraph,5) = Datum5	; x max, y min
  GraphOpt(XGraph,6) = Datum6 & GraphOpt(XGraph,7) = Datum7	; y max, x tick marks
endfor

for XGraph = 0, (DimGraph-1) do begin
  for XName = 0, 3 do begin
    readf, lunSpec, String, format='(a80)'	; names	
    String = strtrim(String,2)
    GiveSymbol, String
    GraphNames(XGraph,XName) = String
  endfor
endfor

free_lun, lunSpec

end
