; may call with either Year0,Year1, or Data, or both, and with ColHeads if desired

pro LoadAnn, CallFile=CallFile,Data=Data,Year0=Year0,Year1=Year1,ColHeads=ColHeads

Trash = "" & LineFormat="" & FileYear0=0 & FileYear1=0 & FileYearAD=0 & NCol=0

FilePath="" & ExitStatus=0
if (keyword_set(CallFile)) then FilePath = CallFile

while (ExitStatus NE 1) do begin				; initial interrogation
 OpenStatus = -1
 if (FilePath EQ "") then print, "  > Enter the filepath of the .ann file: "
 
 while (OpenStatus NE 0) do begin
    if (FilePath EQ "") then read, FilePath
    FilePath = strtrim(FilePath,2)
    openr, lunAnn, FilePath, /get_lun, error=OpenStatus
    if (OpenStatus NE 0) then begin
    	FilePath = ""
    	print, "  > File cannot be opened. Re-enter filepath."
    endif else begin
        ExitStatus=1
        free_lun, lunAnn
    endelse
 endwhile  
endwhile

openr, lunAnn, FilePath, /get_lun

readf, lunAnn, Trash, format='(a80)'
readf, lunAnn, Trash,NCol, format='(a40,i4)'
readf, lunAnn, Trash, FileYear0, Trash, FileYear1, Trash, LineFormat, format='(a9,i4,a1,i4,a36,a20)'

NColLoad=NCol & NColSave=NCol
if (NColSave EQ 1) then NColSave = 2 		; to prevent IDL making vectr when NCol=1

HeadFormat='(a4,' + strtrim(string(NCol)) + 'a9)'
ColHeadsLoad=strarr(NColLoad) & ColHeadsLoad(*)=''
ColHeads=strarr(NColSave) & ColHeads(*)='    blank'
readf, lunAnn, Trash, ColHeadsLoad, format=HeadFormat
for XCol = 0, NColLoad-1 do begin
  ColHeads(XCol)=strtrim(ColHeadsLoad(XCol),2)
endfor

NFileYear = FileYear1 - FileYear0 + 1

Data=fltarr(NFileYear,NColSave)	
Data(*,*)=-999.0
LineData = fltarr(NColLoad)

for XFileYear = 0, NFileYear-1 do begin
  readf, lunAnn, FileYearAD, LineData, format=LineFormat
  for XCol = 0, NColLoad-1 do begin
    Data(XFileYear,XCol) = LineData(XCol)
  endfor
endfor

free_lun, lunAnn

Year0=FileYear0
Year1=FileYear1

end
