pro BoxToCoord, ModelChosen, ExeCoord, WyeCoord, ExeBox, WyeBox

MissVal = -999.0
LongDenom = MissVal & 	LatDenom = MissVal
LongCept  = 0.0 & 	LatCept  = 0.0
ExeCoord  = MissVal & 	WyeCoord = MissVal

if            (ModelChosen EQ 3) then begin	; HadCM2
    LongDenom = 96.0 & LatDenom  = 72.0
    LongCept  =180.0 & LatCept   = 90.0
endif else if (ModelChosen EQ 4) then begin	; HadCM3
    LongDenom = 96.0 & LatDenom  = 72.0
    LongCept  =180.0 & LatCept   = 90.0
endif else if (ModelChosen EQ 12) then begin	; HalfDegree
    LongDenom = 720.0 & LatDenom  = 360.0
    LongCept  = 180.0 & LatCept   =  90.0
endif else if (ModelChosen EQ 13) then begin	; 10'Europe
    LongDenom =2160.0 & LatDenom  =1080.0
    LongCept  =  20.0 & LatCept   = -30.0
endif else if (ModelChosen EQ 15) then begin	; 10'ATEAM
    LongDenom =2160.0 & LatDenom  =1080.0
    LongCept  =  11.0 & LatCept   = -34.0
endif else if (ModelChosen EQ 17) then begin	; 10'Britain
    LongDenom =2160.0 & LatDenom  =1080.0
    LongCept  =  11.0 & LatCept   = -49.0
endif else if (ModelChosen EQ 18) then begin	; Richard Jones
    LongDenom = 144.0 & LatDenom  =  72.0
    LongCept  = 180.0 & LatCept   = -90.0
endif

if (LongCept NE 0) then begin

  ExeCoord = (float(ExeBox) * (360.0 / LongDenom)) - LongCept	; converts to coordinates						
  WyeCoord = (float(WyeBox) * (180.0 / LatDenom )) - LatCept

endif else begin

  print, "  > ##### Error: BoxToCoord: Grid unrecognised #####"

endelse

end
