; plotscatter-ateam.pro
; based on plotscatter.pro 10.02.03
; produces country scatter plots based on the globalised ATEAM data-set

MissVal = -999.0

DateTime  = systime ()
DateStamp = strmid(DateTime,4,7) + strmid(DateTime,20,4)

loadanyct, 33
Black=0 & Grey=254 & White=255

NInfo = 20
InfoText = strarr(NInfo)
InfoText = ['The values are the changes between','the end of the 20th (1961-90)',$
	    'and 21st (2070-99) centuries','from 4 climate models',$
	    'reviewed by the IPCC (2001).','',$
	    'The 4 plots illustrate 4 seasons','(DJF=Dec-Feb, MAM=Mar-May,',$
	    'JJA=Jun-Aug, SON=Sep-Nov)',$
	    'and 4 emissions scenarios','(IPCC SRES: A1FI,A2,B2,B1).','',$
	    'These plots were derived from','data-set TYN SC 2.0,',$
	    'by Dr. T. D. Mitchell.','','cite: Mitchell TD et al, 2003',$
	    'www.cru.uea.ac/uk/~timm','','']

ScenText = strarr(4)
ScenText[*] = ['A1FI','A2','B2','B1']

SeasText = strarr(4)
SeasText[*] = ['DJF','JJA','MAM','SON']

AxisXLabel = "temperature change (degC)"
GiveSymbol, AxisXLabel
AxisYLabel = "precipitation change (%)"

ModelScenText = strarr(4,4)
ModelScenText [0,*] = ['cgcm2.a1fi','cgcm2.a2a','cgcm2.b2a','cgcm2.b1']
ModelScenText [1,*] = ['csiro2.a1a','csiro2.a2a','csiro2.b2a','csiro2.b1a']
ModelScenText [2,*] = ['pcm.a1fi','pcm.a2a','pcm.b2a','pcm.b1']
ModelScenText [3,*] = ['had3.a1fi','had3.a2m','had3.b2m','had3.b1']

GCMText = strarr(4)
GCMText [*] = ['CGCM2','CSIRO mk 2','DOE PCM','HadCM3']

CtyText = strarr(4)
CtyText [*] = ['Canada','Australia','USA','UK']

ScenColor = intarr(4)
ScenColor [*] = [240,180,90,30]

Exes = intarr(5) & Wyes = intarr(5)
Exes(*) = [-1,0,1,0,-1] & Wyes(*) = [0,1,0,-1,0]

SingleTemp=fltarr(1) & SinglePrec=fltarr(1)

RefFile='/cru/u2/f709762/goglo/ref/half-degree-cty-v3.ref'
LoadRef, 12, 720, 360, MapIDLReg, RegSize, RegName, RegColour, NReg, CallFile=RefFile
for XReg = 0, (NReg-1) do begin  
  while (strpos(RegName(XReg),'.') GT -1) do begin
    DotPlace=strpos(RegName(XReg),'.')
    RegText=RegName(XReg) & RegText(DotPlace:DotPlace)=" " & RegName(XReg)=RegText
  endwhile
endfor
RegNameCompress = strcompress(RegName,/remove_all)

;TempData = fltarr(4,4,4,NReg) & PrecData = fltarr(4,4,4,NReg)
;TempData(*,*,*,*) = MissVal & PrecData(*,*,*,*) = MissVal
							; get region info
;for XScen = 0, 3 do begin				; load all data
; for XSeas = 0, 3 do begin				
;  for XModel = 0, 3 do begin
;    print, "  > Loading: ", ScenText[XScen], " ", SeasText[XSeas], " ", GCMText[XModel]
;    
;    TempFile='/cru/tyn1/f709762/tyn_cy_3.0/v3.01/hd-cty.' 
;    TempFile=TempFile + ModelScenText[XModel,XScen] + '.2080s.' + SeasText[XSeas] + '.tmp.glo'
;    LoadGlo, 12, TempSlice, TempFile, FileInfo, Silent=1
;    
;    PrecFile='/cru/tyn1/f709762/tyn_cy_3.0/v3.01/hd-cty.'
;    PrecFile=PrecFile + ModelScenText[XModel,XScen] + '.2080s.' + SeasText[XSeas] + '.prd.glo'
;    LoadGlo, 12, PrecSlice, PrecFile, FileInfo, Silent=1
;    
;    for XLon = 0, 719 do begin
;      for XLat = 0, 359 do begin
;        if (MapIDLReg(XLon,XLat) NE -999) then begin
;        	TempData(XScen,XSeas,XModel,MapIDLReg(XLon,XLat))=TempSlice(XLon,XLat)
;        	PrecData(XScen,XSeas,XModel,MapIDLReg(XLon,XLat))=PrecSlice(XLon,XLat)
;        endif
;      endfor
;    endfor
;  endfor
; endfor
;endfor
    
Missing = where(TempData EQ -999.0, Count) & if (Count GT 0) then TempData(Missing) = !Values.F_NaN
Missing = where(PrecData EQ -999.0, Count) & if (Count GT 0) then PrecData(Missing) = !Values.F_NaN

ScatterTemp = fltarr(9) & ScatterPrec = fltarr(9)
XPixels=20 & YPixels=16
PlotCorners=fltarr(4,4)
for XRow = 0,1 do begin
  for XCol = 0,1 do begin
    XPlot=(XRow*2)+XCol
    PlotCorners(XPlot,1) = 0.50-(XRow*0.40) & PlotCorners(XPlot,3) = 0.75-(XRow*0.40)
    PlotCorners(XPlot,0) = 0.10+(XCol*0.33) & PlotCorners(XPlot,2) = 0.35+(XCol*0.33)
  endfor
endfor

print, "  > Plotting each region to .eps ..."
for XReg = 0, (NReg-1) do begin
  EPSPath='/cru/tyn1/f709762/tyn_cy_3.0/v3.01/cty-v3.' + RegNameCompress(XReg) + '.eps'
  Set_Plot, 'ps', /copy
  device, filename=EPSPath, bits_per_pixel=8, xsize=XPixels, ysize=YPixels, /Color, /Encapsulated
    
  read_jpeg, '/cru/u2/f709762/goglo/ref/tyn-logo-torok.jpg', Logo, LogoCT, colors=256, dither=1, /two_pass_quantize
  tvlct, Red,Green,Blue, /get						; get old colors
  tvlct, LogoCT(*,0), LogoCT(*,1), LogoCT(*,2)
  tv, Logo, 0.04,0.89,xsize=0.834*0.3*(7.0/9.0),ysize=0.184*0.3,/normal
  tvlct, Red,Green,Blue							; restore old colors

  xyouts,0.95,0.93,'Dr. Timothy D. Mitchell',/normal,alignment=1,charsize=0.7,charthick=1,font=5
  xyouts,0.95,0.91,DateStamp,/normal,alignment=1,charsize=0.7,charthick=1,font=5
  xyouts,0.95,0.89,'www.tyndall.ac.uk',/normal,alignment=1,charsize=0.7,charthick=1,font=5
  xyouts,0.50,0.93,strtrim(RegName(XReg),2),alignment=0.5,charsize=2,charthick=2,font=5,/normal
  xyouts,0.50,0.89,'21st century climate changes',alignment=0.5,charsize=1,charthick=1,font=5,/normal
  
  MaxTemp=max(TempData(*,*,*,XReg)) & MinTemp=min(TempData(*,*,*,XReg))
  MaxPrec=max(PrecData(*,*,*,XReg)) & MinPrec=min(PrecData(*,*,*,XReg))
  if (MaxTemp LT  1) then MaxTemp=1 
  if (MinTemp GT -1) then MinTemp=-1
  if (MaxPrec LT  5) then MaxPrec=5 
  if (MinPrec GT -5) then MinPrec=-5
  
  for XSeas = 0, 3 do begin				
   plot, [MinTemp,MaxTemp],[MinPrec,MaxPrec], $			; to get good data limits
  	Background=White,Color=Black,$				; colour		
  	Title=SeasText(XSeas),$					; plot title
  	XTitle=AxisXLabel ,$					; x axis title
  	YTitle=AxisYLabel,$					; y axis title  	
  	XTickLen=1.0,YTickLen=1.0,XGridStyle=1,YGridStyle=1, $  ; grid
  	XRange=[MinTemp,MaxTemp],YRange=[MinPrec,MaxPrec],$	; axis limits
	font=5,charsize=1.0,xcharsize=0.7,ycharsize=0.7, $	; character sizes
  	/NoData,position=PlotCorners[XSeas,*],/NoErase
    
   for XScen = 0, 3 do begin
     for XModel = 0, 3 do begin
       SingleTemp[0]=TempData[XScen,XSeas,XModel,XReg]
       SinglePrec[0]=PrecData[XScen,XSeas,XModel,XReg]
       oplot, SingleTemp,SinglePrec, psym=(4+XModel),color=ScenColor[XScen]
     endfor
   endfor

   plots,!X.CRange,[0,0],linestyle=0,thick=2,color=Black,/data	; plot heavy axes
   plots,[0,0],!Y.CRange,linestyle=0,thick=2,color=Black,/data
  endfor
  
  xyouts,0.73,0.80,'KEY',/normal,alignment=0,charsize=1,charthick=1,font=5  
  for XScen = 0, 3 do begin					; key to emissions
    usersym,Exes,Wyes,/fill,color=ScenColor[XScen]
    plots, 0.74,0.80-((XScen+1)*0.03), psym=-8, /normal
    xyouts, 0.76,0.795-((XScen+1)*0.03), ScenText[XScen],/normal,alignment=0,charsize=0.7, $
    				charthick=1,font=5,color=Black
  endfor
  for XModel = 0, 3 do begin					; key
    plots, 0.74,0.80-((XModel+6)*0.03), psym=(4+XModel),color=Black, /normal
    xyouts, 0.76,0.795-((XModel+6)*0.03), GCMText[XModel],/normal,alignment=0,charsize=0.7, $
    				charthick=1,font=5,color=Black
    xyouts, 0.88,0.795-((XModel+6)*0.03), CtyText[XModel],/normal,alignment=0,charsize=0.7, $
    				charthick=1,font=5,color=Black
  endfor
  
  xyouts,0.73,0.46,'INFORMATION',/normal,alignment=0,charsize=1,charthick=1,font=5  
  for XInfo = 0, (NInfo-1) do begin
    xyouts, 0.73,0.44-((XInfo+1)*0.02), InfoText[XInfo],/normal,alignment=0,charsize=0.7, $
    				charthick=1,font=5,color=Black
  endfor
  
  device, /close
  set_plot, 'X'
endfor

end
