; plotlins.pro
; program that loads .lin files and plots the lines
; written by Tim Mitchell on 09.03.99
; last modified on 29.06.01
; if there is a single plot there is capability for a key

;*******************************************************************************

DatumFlt = 0.0D & DatumFlt0= 0.0D & DatumFlt1= 0.0D & DatumFlt2= 0.0D
DatumFlt3= 0.0D & DatumFlt4= 0.0D & DatumFlt5= 0.0D & DatumFlt6= 0.0D
DatumFlt7= 0.0D & DatumFlt8= 0.0D & DatumFlt9= 0.0D
DatumInt = 0L & DatumInt1= 0L & DatumInt2= 0L & DatumInt3= 0L
DatumCha = "oopsadaisy" & DatumChr = "oopsadaisy"

EndPoints = dblarr (2,2)

MissVal = -999.0D

print, ""
print, "  > ***** plotlins.pro plots .lin data *****"
print, ""

print, "  > Enter the colour table:"
read, ColourTable
LoadAnyCT, ColourTable

Black = 0 & White = 255
PlotSizeFactor = 150
QInfoBar = 1 & QLogoBar = 1 & QKeyBar = 1 
MyCharSize  = 1.0 & MyCharThick = 1.0

KeyCorners     = fltarr (4)
KeyCorners [*] = [0.78,0.00,1.00,1.00]

;*******************************************************************************
; main loop
Choice = -2				; no initial option
ActiveGraph = 0

PlotOpt       = intarr (3)		; some arrays initialised to keep       
GraphOpt      = dblarr (1,13)		; the program happy in the plot section
GraphNames    = strarr (1,4)		; after 'case' ends
DimGraph      = 1	
GraphOpt[*,*] = MissVal		

while (Choice NE 99) do begin

case 1 of

;*******************************************************************************

(Choice EQ 0) : begin

print, "  > INITIALISE graphs."

print, "  > Load graph spec from file (=1) or manually (=2) ? "
read, QFileMan

if (QFileMan EQ 1) then begin
  LoadGraphSpec, DimGraph,PlotOpt,GraphOpt,GraphNames
endif else begin
  print, "  > Specify the number of graphs: "
  read, DimGraph

  PlotOpt    = intarr (3)      
  GraphOpt   = dblarr (DimGraph,8)
  GraphNames = strarr (DimGraph,4)

  print, "  > Specify the number of columns: "
  read, DatumInt
  PlotOpt(0) = DatumInt
  
  print, "  > Specify the number of rows: "
  read, DatumInt
  PlotOpt(1) = DatumInt
  PlotOpt(2) = 0
  
  GraphOpt   [*] = 0
  GraphNames [*] = ""
endelse

GetCorners, [0.0,0.0,0.78,1.0], PlotCorners, PlotOpt[0], PlotOpt[1], PlotOpt[2]
PlotCorners [*,0] = PlotCorners [*,0] + 0.1
PlotCorners [*,1] = PlotCorners [*,1] + 0.1

Equations   = dblarr (LineN,3)

GraphLines  = intarr (DimGraph,LineN,5)
GraphEq     = intarr (DimGraph,LineN,5)
ScatterPlot = intarr (DimGraph,LineN,LineN,5)

GraphLinesText = strarr (DimGraph,LineN)
GraphEqText    = strarr (DimGraph,LineN)
ScatterText    = strarr (DimGraph,LineN,LineN)

Equations [*,*] = MissVal	; y=a+bx+cxx  0=a 1=b 2=c

GraphEq [*,*,0] = 0		; 0=none 1=simple 2=one-v-another
GraphEq [*,*,1] = Black		; default line colour = black
GraphEq [*,*,2] = 0		; default line style = solid
GraphEq [*,*,3] = 1		; default thickness = usual
GraphEq [*,*,4] = 0		; default symbol = none

GraphLines [*,*,0] = 0		; 0=none 1=simple 2=one-v-another
GraphLines [*,*,1] = Black	; default line colour = black
GraphLines [*,*,2] = 0		; default line style = solid
GraphLines [*,*,3] = 1		; default thickness = usual
GraphLines [*,*,4] = 0		; default symbol = none

ScatterPlot [*,*,*,0] = 0	; 0=no plot for this combination
ScatterPlot [*,*,*,1] = Black   ; default colour
ScatterPlot [*,*,*,2] = 0   	; default style = solid
ScatterPlot [*,*,*,3] = 3   	; default thick = usual
ScatterPlot [*,*,*,4] = 3   	; default symbol = period

GraphLinesText [*,*]   = " "	; default = blank
GraphEqText    [*,*]   = " "	; default = blank
ScatterText    [*,*,*] = " "	; default = blank

print, "  > Graph arrays initialised to default values."
print, ""

end
  
;*******************************************************************************

(Choice EQ 1) : begin

LinTitle  = ""
LinFormat = ""
LinFile   = ""
print, "  > LOADING .lin file"
print, "  > i. Enter the path/name of the file: "

OpenStatus = -1
while (OpenStatus NE 0) do begin
  read, LinFile
  openr, lunLin, LinFile, /get_lun, error=OpenStatus
endwhile  

  readf, lunLin, LinTitle, format='(a80)'			; title
  readf, lunLin, LinFormat, format='(a10)'			; format
  readf, lunLin, LineN, TimeN, format='(2(i6))'		; dims

  print, strtrim(LinTitle,2)

  Time      = dblarr (LineN,TimeN)
  Time[*,*] = MissVal
  Data      = dblarr (LineN,TimeN)
  Data[*,*] = MissVal
  Name      = strarr (LineN)
  Name[*]   = ""
   
  for XLine = 0, (LineN-1) do begin
	readf, lunLin, DatumCha, format='(a80)'
        DatumCha = strtrim(DatumCha, 2)
	Name [XLine] = DatumCha				; names
  endfor

  for XLine = 0, (LineN-1) do begin
    for XTime = 0, (TimeN-1) do begin
	readf, lunLin, DatumFlt, format=LinFormat
	if (DatumFlt EQ MissVal) then DatumFlt = !Values.F_NaN
	Time [XLine,XTime] = DatumFlt			; times
    endfor
  endfor

  for XLine = 0, (LineN-1) do begin
    for XTime = 0, (TimeN-1) do begin
	readf, lunLin, DatumFlt, format=LinFormat
	if (DatumFlt EQ MissVal) then DatumFlt = !Values.F_NaN
	Data [XLine,XTime] = DatumFlt			; prec
    endfor
  endfor

  free_lun, lunLin

print, "  > Data loaded. Now choose option ZERO."
print, ""

end

;*******************************************************************************

(Choice EQ 2) : begin

print, "  > CHANGE PLOT APPEARANCE. "
print, "  > Include right-hand info bar (0=no 1=yes) ?"
read, QInfoBar

if (QInfoBar EQ 1) then begin
  print, "  > Include logo, attribution, date stamp (0=no 1=yes) ?"
  read, QLogoBar

  print, "  > Include key (0=no 1=yes) ?"
  read, QKeyBar
  
  GetCorners, [0.0,0.0,0.78,1.0], PlotCorners, PlotOpt[0], PlotOpt[1], PlotOpt[2]
endif else begin
  GetCorners, [0.0,0.0,1.00,1.0], PlotCorners, PlotOpt[0], PlotOpt[1], PlotOpt[2]
endelse

PlotCorners [*,0] = PlotCorners [*,0] + 0.1
PlotCorners [*,1] = PlotCorners [*,1] + 0.1

end

;*******************************************************************************

(Choice EQ 3) : begin

print, "  > GRAPH DEFAULTS respecification"

print, "  > a. default inclusion of graph (0=no 1=yes) ?"
read, DatumInt
GraphOpt      [*,0] = DatumInt

print, "  > b. default axis colour ? (black... ", Black
read, DatumInt
GraphOpt      [*,1] = DatumInt

print, "  > c. default axis constraint (0=no 1=yes) ?"
read, DatumInt
GraphOpt      [*,2] = DatumInt

print, "  > d. define identical axes for each graph (0=no 1=yes) ?"
read, MiniChoice
if (MiniChoice EQ 1) then begin
	print, "  >    x-axis min and max: "
	read, DatumFlt1, DatumFlt2
	GraphOpt      [*,3] = DatumFlt1
	GraphOpt      [*,4] = DatumFLt2
	print, "  >    y-axis min and max: "
	read, DatumFlt1, DatumFlt2
	GraphOpt      [*,5] = DatumFLt1
	GraphOpt      [*,6] = DatumFlt2	
endif

print, "  > e. default no. of x-axis tick intervals ?"
read, DatumInt
GraphOpt      [*,7] = DatumInt

print, "  > f. default x-axis label ?"
read, DatumCha
GiveSymbol, DatumCha
GraphNames [*,2] = DatumCha

print, "  > f. default y-axis label ?"
read, DatumCha
GiveSymbol, DatumCha
GraphNames [*,3] = DatumCha

print, ""

end

;*******************************************************************************

(Choice EQ 4) : begin

MiniChoice = -1
print, "  > CHANGE graph properties"

while (MiniChoice NE 99) do begin
  if (MiniChoice EQ 1) then begin
    print, "  >      DISPLAY graph (0:no 1:yes) ?"
    read, DatumInt
    GraphOpt[DatumInt2,0] = DatumInt
  endif
  
  if (MiniChoice EQ 2) then begin
    print, "  >      Enter COLOUR of axes: (black... ", Black
    read, DatumInt
    GraphOpt[DatumInt2,1] = DatumInt
  endif
  
  if (MiniChoice EQ 3) then begin
    print, "  >      CONSTRAIN axes to user's limits (0:no 1:yes) ?"
    read, DatumInt
    GraphOpt[DatumInt2,2] = DatumInt
  endif
  
  if (MiniChoice EQ 4) then begin
    print, "  >      Enter X-AXIS limits (min,max): "
    read, DatumFlt1, DatumFlt2
    GraphOpt[DatumInt2,3] = DatumFlt1
    GraphOpt[DatumInt2,4] = DatumFlt2    
  endif
  
  if (MiniChoice EQ 5) then begin
    print, "  >      Enter Y-AXIS limits (min,max): "
    read, DatumFlt1, DatumFlt2
    GraphOpt[DatumInt2,5] = DatumFlt1
    GraphOpt[DatumInt2,6] = DatumFlt2    
  endif
  
  if (MiniChoice EQ 6) then begin
    print, "  >      Enter TITLE:"
    read, DatumCha
    GiveSymbol, DatumCha
    GraphNames[DatumInt2,0] = DatumCha
    print, "  >      Enter SUBTITLE:"
    read, DatumCha
    GiveSymbol, DatumCha
    GraphNames[DatumInt2,1] = DatumCha
    print, "  >      Enter X-AXIS title:"
    read, DatumCha
    GiveSymbol, DatumCha
    GraphNames[DatumInt2,2] = DatumCha
    print, "  >      Enter Y-AXIS title:"
    read, DatumCha     
    GiveSymbol, DatumCha
    GraphNames[DatumInt2,3] = DatumCha
  endif

  if (MiniChoice EQ 7) then begin
    print, "  >      Enter no. of x-axis TICK INTERVALS:"
    read, DatumInt     
    GraphOpt[DatumInt2,7] = DatumInt    
  endif

  if (Minichoice EQ 0) then begin  
    print, "  >    Change: "
    print, "  >      1. displaying of graph"
    print, "  >      2. axes colour"
    print, "  >      3. axis limits constraint"
    print, "  >      4. x-axis limits"
    print, "  >      5. y-axis limits"
    print, "  >      6. titles"
    print, "  >      7. no. of x-axis tick intervals" 
    print, "  >     99. nothing (exit)" 
  endif
  
  print, "  >    Enter choice (0=list,99=end): "
  read, MiniChoice
  print, "  >    Enter graph: "
  read, DatumInt2
endwhile

print, ""

end

;*******************************************************************************

(Choice EQ 5) : begin

XLine = -1

print, "  > Plot one line against another (scatter only): "

GetLineSpec, QCol,QSty,QThi,QSym,QKey

print, "  > Enter graph, X-line, Y-line to plot thus (99,99,99 = finish): "
LineX  = -1 & LineY  = -1 & XGraph = -1 & DoneText = 0
while (LineX NE 99 AND XGraph NE 99 AND LineY NE 99) do begin
  if (XGraph GE 0 AND XGraph LT DimGraph) then begin

   GraphOpt[XGraph,0] = 2		; graph = one-v-another plot

   if (LineX GE 0 AND LineX LT LineN) then begin
    if (LineY GE 0 AND LineY LT LineN) then begin
       ScatterPlot[XGraph,LineX,LineY,0] = 1
       ScatterPlot[XGraph,LineX,LineY,1] = QCol
       ScatterPlot[XGraph,LineX,LineY,2] = QSty
       ScatterPlot[XGraph,LineX,LineY,3] = QThi
       ScatterPlot[XGraph,LineX,LineY,4] = QSym
       
       if (DoneText EQ 0) then ScatterText[XGraph,LineX,LineY] = QKey
       
       DoneText = DoneText + 1
    endif
   endif
  endif
  
  read, XGraph, LineX, LineY
endwhile

print, ""

end

;*******************************************************************************

(Choice EQ 6) : begin

XLine = -1

print, "  > Plot lines on graphs: "

GetLineSpec, QCol,QSty,QThi,QSym,QKey

print, "  > Enter graph, line to plot thus (99,99 = finish): "
XLine  = -1 & XGraph = -1 & DoneText = 0
while (XLine NE 99 OR XGraph NE 99) do begin
    if (XGraph GE 0 AND XGraph LT DimGraph) then begin

     GraphOpt[XGraph,0] = 1		; graph = simple plot

     if (XLine GE 0 AND XLine LT LineN) then begin
       GraphLines[XGraph,XLine,0] = 1	; line plotted
       GraphLines[XGraph,XLine,1] = QCol
       GraphLines[XGraph,XLine,2] = QSty
       GraphLines[XGraph,XLine,3] = QThi
       GraphLines[XGraph,XLine,4] = QSym
       
       if (DoneText EQ 0) then GraphLinesText[XGraph,XLine] = QKey
       
       DoneText = DoneText + 1
     endif
    
    endif
    read, XGraph, XLine
endwhile

print, ""

end

;*******************************************************************************

(Choice EQ 7) : begin

XLine = -1

print, "  > Plot EQUATIONS on graphs: "

GetLineSpec, QCol,QSty,QThi,QSym,QKey

print, "  > Enter graph, equation to plot thus (99,99 = finish): "
XLine  = -1 & XGraph = -1 & DoneText = 0
while (XLine NE 99 AND XGraph NE 99) do begin
    if (XGraph GE 0 AND XGraph LT DimGraph) then begin

     if (XLine GE 0 AND XLine LT LineN) then begin
      if (Equations[XLine,0] NE MissVal) then begin
       GraphEq[XGraph,XLine,0] = 1		; equation plotted
       GraphEq[XGraph,XLine,1] = QCol
       GraphEq[XGraph,XLine,2] = QSty
       GraphEq[XGraph,XLine,3] = QThi
       GraphEq[XGraph,XLine,4] = QSym
       
       if (DoneText EQ 0) then GraphEqText[XGraph,XLine] = QKey
       
       DoneText = DoneText + 1
      endif
     endif
    
    endif
    read, XGraph, XLine
endwhile

print, ""

end

;*******************************************************************************

(Choice EQ 8) : begin

XLine = -1
QVariety = 0

print, "  > REMOVING lines from graphs: "
print, "  > Enter the sort of line: (1=simple,2=one-v-another,3=equation)"
read, QVariety

if (QVariety EQ 1) then begin
  print, "  > Enter graph, line to remove (99,99 = finish): "
  XLine  = -1
  XGraph = -1
  while (XLine NE 99 AND XGraph NE 99) do begin
   if (XGraph GE 0 AND XGraph LT DimGraph) then begin    
     if (XLine GE 0 AND XLine LT LineN) then begin
       GraphLines[XGraph,XLine,0] = 0	; line removed
     endif
   endif
   
   read, XGraph, XLine
  endwhile
endif

if (QVariety EQ 2) then begin
  print, "  > Enter graph, line-X, line-Y to remove (99,99,99 = finish): "
  LineX  = -1
  LineY  = -1
  XGraph = -1
  
  while (LineX NE 99 AND XGraph NE 99 AND LineY NE 99) do begin
   if (XGraph GE 0 AND XGraph LT DimGraph) then begin    
     if (LineX GE 0 AND LineX LT LineN) then begin
      if (LineY GE 0 AND LineY LT LineN) then begin
	ScatterPlot[XGraph,LineX,LineY,0] = 0
      endif
     endif
   endif
   
   read, XGraph, LineX, LineY
  endwhile
endif

if (QVariety EQ 3) then begin
  print, "  > Enter graph, equation to remove (99,99 = finish): "
  XLine  = -1
  XGraph = -1
  while (XLine NE 99 AND XGraph NE 99) do begin
   if (XGraph GE 0 AND XGraph LT DimGraph) then begin    
     if (XLine GE 0 AND XLine LT LineN) then begin
       GraphEq[XGraph,XLine,0] = 0	; equation removed
     endif
   endif
   
   read, XGraph, XLine
  endwhile
endif

print, ""

end

;*******************************************************************************

(Choice EQ 9) : begin

print, "  > Define EQUATIONS of the form y = a + bx + cxx"
print, "  > Enter a,b,c (99,99,99=end)"
ValA  = -1.0D
ValB  = -1.0D
ValC  = -1.0D
XLine = -1

while (ValA NE 99 AND ValB NE 99 AND ValC NE 99) do begin
  if (XLine GE 0 AND XLine LT LineN) then begin
    Equations[XLine,0] = ValA
    Equations[XLine,1] = ValB
    Equations[XLine,2] = ValC    
  endif
    
  XLine = XLine + 1
  read, ValA, ValB, ValC
endwhile

print, "  > These are the equations: " 
for Index = 0, (XLine-1) do begin
  if (Equations[Index,0] NE MissVal) then begin
    print, Index, ' :  y = ', Equations[Index,0], ' + ', Equations[Index,1], ' x + ', $
    		Equations[Index,2], ' xx'
  endif
endfor

print, ""

end

;*******************************************************************************

(Choice EQ 10) : begin

PSPath = "gobbledegook"
Encaps = 0
print, "  > Enter the PostScript filepath:"
read, PSPath

Set_Plot, 'ps', /copy
device, filename=PSPath, bits_per_pixel=8, /Color, /encapsulated

for XGraph = 0, (DimGraph-1) do begin		; loops for each graph
 
 if (GraphOpt[XGraph,0] GT 0) then begin  		; is graph wanted?
  
    plot, Time[0,*], Data[0,*], $			; random line
  	Background=White,$					; background colour
  	Color=GraphOpt[XGraph,1],$				; colour		
  	XStyle=(GraphOpt[XGraph,2]+8), $			; axis constraint ?
  	YStyle=8, $						; draws only one axis
  	XRange=[GraphOpt[XGraph,3],GraphOpt[XGraph,4]],$	; x axis limits
  	YRange=[GraphOpt[XGraph,5],GraphOpt[XGraph,6]],$	; y axis limits
  	Title=GraphNames[XGraph,0],$				; title
  	SubTitle=GraphNames[XGraph,1],$				; subtitle
  	XTitle=GraphNames[XGraph,2],$				; x axis title
  	YTitle=GraphNames[XGraph,3],$				; y axis title  	
  	XTicks=GraphOpt[XGraph,7],$				; tick marks
  	CharSize=MyCharSize,$ 					; size of annotations
  	CharThick=MyCharThick,$					; thickness of annotations
	XThick=MyCharThick,YThick=MyCharThick,$			; axis thicknesses
  	/NoData,font=5, $
  	position=PlotCorners[XGraph,*],/noerase 
  
 endif
  

 if (GraphOpt[XGraph,0] EQ 1) then begin		; simple plot
  
   for XLine = 0, (LineN-1) do begin			; loops for each line

    if (GraphLines[XGraph,XLine,0] EQ 1) then begin		; is line wanted?
      
      oplot, Time[XLine,*], Data[XLine,*], $		; plot line
        Color=GraphLines[XGraph,XLine,1], $			; colour
        LineStyle=GraphLines[XGraph,XLine,2], $			; line style
        Thick=GraphLines[XGraph,XLine,3], $			; line thickness
        PSym=GraphLines[XGraph,XLine,4]				; symbol
      
    endif
    
   endfor
   
 endif
           

 if (GraphOpt[XGraph,0] EQ 2) then begin		; one line versus another
  
   for LineX = 0, (LineN-1) do begin			; loops for each line
    for LineY = 0, (LineN-1) do begin
    
     if (ScatterPlot[XGraph,LineX,LineY,0] EQ 1) then begin	; is line wanted?
      
      oplot, Data[LineX,*], Data[LineY,*], $		; plot line
        Color 	  = ScatterPlot[XGraph,LineX,LineY,1], $	; colour
        LineStyle = ScatterPlot[XGraph,LineX,LineY,2], $	; line style
        Thick     = ScatterPlot[XGraph,LineX,LineY,3], $	; line thickness
        PSym      = ScatterPlot[XGraph,LineX,LineY,4]		; symbol
      
     endif
    
    endfor
   endfor
   
 endif
           

 for XLine = 0, (LineN-1) do begin			; loops for each equation
   if (GraphEq[XGraph,XLine,0] EQ 1) then begin		; is equation wanted?
      
      PointsN = 500
      Interval = double ((GraphOpt[XGraph,4] - GraphOpt[XGraph,3]) / (PointsN-1))
      AllPoints = dblarr (PointsN,2)
      AllPoints[*,*] = MissVal
      
      for XPoint = 0, (PointsN-1) do begin
        AllPoints[XPoint,0] = GraphOpt[XGraph,3] + Interval * XPoint
        AllPoints[XPoint,1] = Equations[XLine,0] $
        		    + Equations[XLine,1] * AllPoints[XPoint,0] $
        		    + Equations[XLine,2] * AllPoints[XPoint,0] * AllPoints[XPoint,0]
      endfor
      
      oplot, AllPoints[*,0], AllPoints[*,1], $			; plot line
        Color=GraphEq[XGraph,XLine,1], $			; colour
        LineStyle=GraphEq[XGraph,XLine,2], $			; line style
        Thick=GraphEq[XGraph,XLine,3], $			; line thickness
        PSym=GraphEq[XGraph,XLine,4]				; symbol
      
   endif
 endfor
           
endfor

if (QInfoBar EQ 1) then begin
  if (QLogoBar EQ 1 AND QKeyBar EQ 1) then DrawKey,KeyCorners,GraphLines,GraphLinesText,GraphEq,GraphEqText, $
  	ScatterPlot,ScatterText,MyCharSize,MyCharThick,/DrawLogo,/DrawDate,/DrawAuth,/DrawKey
  if (QLogoBar EQ 1 AND QKeyBar NE 1) then DrawKey,KeyCorners,GraphLines,GraphLinesText,GraphEq,GraphEqText, $
  	ScatterPlot,ScatterText,MyCharSize,MyCharThick,/DrawLogo,/DrawDate,/DrawAuth
  if (QLogoBar NE 1 AND QKeyBar EQ 1) then DrawKey,KeyCorners,GraphLines,GraphLinesText,GraphEq,GraphEqText, $
  	ScatterPlot,ScatterText,MyCharSize,MyCharThick,/DrawKey
endif

device, /close
set_plot, 'X'	

end

;*******************************************************************************

(Choice EQ 11) : begin

LinFileN    = 0
LineMaxPoss = 0
TimeMaxPoss = 0

print, "  > LOADING MULTIPLE .lin files"
print, "  > Enter the number of files to load:"
read, LinFileN
print, "  > Enter the max possible no. of lines, and time steps:"
read, LineMaxPoss, TimeMaxPoss

Time      = dblarr (LineMaxPoss,TimeMaxPoss)
Time[*,*] = MissVal
Data      = dblarr (LineMaxPoss,TimeMaxPoss)
Data[*,*] = MissVal
Name      = strarr (LineMaxPoss)
Name[*]   = ""
print, "  > Data arrays initialised."

LoadFilePaths, LinFileN, AllFiles
   
FirstFree = 0 & MaxTime = 0 & ErrorStatus = 1

for XLinFile = 1, LinFileN do begin
  LinTitle  = "" & LinFormat = "" & LinFile   = ""
  GivenPath = AllFiles [XLinFile-1]
 
  OpenStatus = -1
  while (OpenStatus NE 0) do begin
    LinFile = strtrim (GivenPath)
    
    if (strlen(GivenPath) EQ 0) then begin
    	print, "  > Enter the path/name of file: ", XLinFile
        read, LinFile
    endif
    
    openr, lunLin, LinFile, /get_lun, error=OpenStatus
    if (ErrorStatus NE 0) then LinFile = " "
  endwhile  

  readf, lunLin, LinTitle, format='(a80)'		; title
  readf, lunLin, LinFormat, format='(a10)'		; format
  readf, lunLin, LineN, TimeN, format='(2(i6))'		; dims

  if (LinFile NE strtrim (GivenPath)) then print, strtrim(LinTitle,2)
  
  if (TimeN GT MaxTime) then MaxTime = TimeN
  
  for XLine = FirstFree, (FirstFree+LineN-1) do begin
	readf, lunLin, DatumCha, format='(a80)'
        DatumCha = strtrim(DatumCha, 2)
	Name [XLine] = DatumCha				; names
  endfor

  for XLine = FirstFree, (FirstFree+LineN-1) do begin
    for XTime = 0, (TimeN-1) do begin
	readf, lunLin, DatumFlt, format=LinFormat
	if (DatumFlt EQ MissVal) then DatumFlt = !Values.F_NaN
	Time [XLine,XTime] = DatumFlt			; times
    endfor
  endfor

  for XLine = FirstFree, (FirstFree+LineN-1) do begin
    for XTime = 0, (TimeN-1) do begin
	readf, lunLin, DatumFlt, format=LinFormat
	if (DatumFlt EQ MissVal) then DatumFlt = !Values.F_NaN
	Data [XLine,XTime] = DatumFlt			; prec
    endfor
  endfor

  free_lun, lunLin

  FirstFree = FirstFree + LineN
endfor

LineN = FirstFree
TimeN = MaxTime

print, "  > Data loaded. Now choose option ZERO."
print, ""

end

;*******************************************************************************

(Choice EQ 12) : begin

print, "  > DEFINE each graph's Y-AXIS limits in turn: "

for XGraph = 0, (DimGraph-1) do begin
  print, "  > Graph: ", XGraph
  read, DatumFlt1, DatumFlt2
  GraphOpt[XGraph,5] = DatumFlt1
  GraphOpt[XGraph,6] = DatumFlt2      
endfor

print, ""
  
end

;*******************************************************************************

(Choice EQ 13) : begin

LoadTim, LineN, TimeN, Name, YearAD, Data
  
Time      = dblarr (LineN,TimeN)
Time[*,*] = MissVal

for XLine = 0, (LineN-1) do begin
  for XTime = 0, (TimeN-1) do begin
    Time[XLine,XTime] = YearAD[XTime]
  endfor
endfor

print, "  > Data loaded. Now choose option ZERO."
print, ""

end

;*******************************************************************************

(Choice EQ 14) : begin

TimFileN    = 0
LineMaxPoss = 0
TimeMaxPoss = 0

print, "  > LOADING MULTIPLE .tim files"
print, "  > Enter the number of files to load:"
read, TimFileN
print, "  > Enter the max possible no. of lines, and time steps:"
read, LineMaxPoss, TimeMaxPoss

Time      = dblarr (LineMaxPoss,TimeMaxPoss)
Time[*,*] = MissVal
Data      = dblarr (LineMaxPoss,TimeMaxPoss)
Data[*,*] = MissVal
Name      = strarr (LineMaxPoss)
Name[*]   = ""
print, "  > Data arrays initialised."
   
FirstFree = 0
MaxTime   = 0

for XTimFile = 1, TimFileN do begin
  TimTitle  = ""
  TimFormat = ""
  TimFile   = ""
  RightFile = ""
  UnCompComm= ""
  FirstTry  = 0

  print, "  > Enter the path/name of .tim file (include any .Z): ", XTimFile
  
  OpenStatus = -1
  while (OpenStatus NE 0) do begin
   read, TimFile
   QCompressed = strpos (TimFile, '.Z')
  
   if (QCompressed EQ -1) then begin				; not compressed
    openr, lunTim, TimFile, /get_lun, error=OpenStatus
    if (OpenStatus NE 0) then print, "  > File does not open. Change the filepath."        
   endif else begin						; compressed
    openr, lunTim, TimFile, /get_lun, error=OpenStatus
    
    if (OpenStatus NE 0) then begin
      print, "  > File does not open. Change the filepath."
    endif else begin
      free_lun, lunTim
      RightFile = '/cru/u2/f709762/data/scratch/uncompressed.file'
      UnCompComm = 'uncompress -c ' + strtrim(TimFile,2) + ' > ' + strtrim(RightFile,2)
      spawn, UnCompComm 
    
      openr, lunTim, RightFile, /get_lun, error=OpenStatus
      if (OpenStatus NE 0) then begin
      	print, "  > Uncompressed file does not open. Program error."
      	RmComm = 'rm ' + strtrim(RightFile,2)
      	spawn, RmComm
      endif
    endelse 
   endelse
  endwhile

  readf, lunTim, TimTitle, format='(a80)'			; title
  readf, lunTim, TimFormat, format='(a10)'			; format
  readf, lunTim, LineN, TimeN, format='(2(i6))'		; dims

  print, "  > File details: "
  print, strtrim(TimTitle,2)
  print, strtrim(TimFormat,2)
  print, LineN, TimeN
    
  if (TimeN GT MaxTime) then MaxTime = TimeN
  
  for XLine = FirstFree, (FirstFree+LineN-1) do begin
	readf, lunTim, DatumCha, format='(a80)'
        DatumCha = strtrim(DatumCha, 2)
	Name [XLine] = DatumCha				; names
  endfor

  for XTime = 0, (TimeN-1) do begin
	readf, lunTim, DatumInt, format='(i4)'
	Time [*,XTime] = DatumInt				; times
  endfor

  TimeTenN = TimeN / 10

  for XLine = FirstFree, (FirstFree+LineN-1) do begin
    for XTen = 0, (TimeTenN-1) do begin
	readf, lunTim, DatumFlt0, DatumFlt1, DatumFlt2, DatumFlt3, $
		       DatumFlt4, DatumFlt5, DatumFlt6, DatumFlt7, $ 
		       DatumFlt8, DatumFlt9, format=TimFormat
	Data [XLine,(XTen*10+0)] = DatumFlt0
	Data [XLine,(XTen*10+1)] = DatumFlt1
	Data [XLine,(XTen*10+2)] = DatumFlt2
	Data [XLine,(XTen*10+3)] = DatumFlt3
	Data [XLine,(XTen*10+4)] = DatumFlt4
	Data [XLine,(XTen*10+5)] = DatumFlt5
	Data [XLine,(XTen*10+6)] = DatumFlt6
	Data [XLine,(XTen*10+7)] = DatumFlt7
	Data [XLine,(XTen*10+8)] = DatumFlt8
	Data [XLine,(XTen*10+9)] = DatumFlt9
    endfor
  endfor

  free_lun, lunTim

  if (QCompressed NE -1) then begin
      	RmComm = 'rm ' + strtrim(RightFile,2)
      	spawn, RmComm
  endif

  FirstFree = FirstFree + LineN
endfor

for XTime = 0, (TimeMaxPoss-1) do begin
  if (Time[0,XTime] EQ MissVal) then Time [*,XTime] = !Values.F_NaN
  
  for XLine = 0, (LineMaxPoss-1) do begin
    if (Data [XLine,XTime] EQ MissVal) then Data [XLine,XTime] = !Values.F_NaN
  endfor
endfor

LineN = FirstFree
TimeN = MaxTime

print, "  > Data loaded. Now choose option ZERO."
print, ""

end

;*******************************************************************************

(Choice EQ 15) : begin

LinFileN    = 0
TimFileN    = 0
LineMaxPoss = 0
TimeMaxPoss = 0

print, "  > LOADING MULTIPLE .tim and .lin files"
print, "  > Enter the number of .tim files to load:"
read, TimFileN
print, "  > Enter the number of .lin files to load:"
read, LinFileN
print, "  > Enter the max possible no. of lines, and time steps:"
read, LineMaxPoss, TimeMaxPoss

Time      = dblarr (LineMaxPoss,TimeMaxPoss)
Time[*,*] = MissVal
Data      = dblarr (LineMaxPoss,TimeMaxPoss)
Data[*,*] = MissVal
Name      = strarr (LineMaxPoss)
Name[*]   = ""
print, "  > Data arrays initialised."
   
FirstFree = 0
MaxTime   = 0

for XTimFile = 1, TimFileN do begin
  TimTitle  = ""
  TimFormat = ""
  TimFile   = ""
  RightFile = ""
  UnCompComm= ""
  FirstTry  = 0

  print, "  > Enter the path/name of the .tim file (including any .Z): ", XTimFile
  
  OpenStatus = -1
  while (OpenStatus NE 0) do begin
   read, TimFile
   QCompressed = strpos (TimFile, '.Z')
  
   if (QCompressed EQ -1) then begin				; not compressed
    openr, lunTim, TimFile, /get_lun, error=OpenStatus
    if (OpenStatus NE 0) then print, "  > File does not open. Change the filepath."        
   endif else begin						; compressed
    openr, lunTim, TimFile, /get_lun, error=OpenStatus
    
    if (OpenStatus NE 0) then begin
      print, "  > File does not open. Change the filepath."
    endif else begin
      free_lun, lunTim
      RightFile = '/cru/u2/f709762/data/scratch/uncompressed.file'
      UnCompComm = 'uncompress -c ' + strtrim(TimFile,2) + ' > ' + strtrim(RightFile,2)
      spawn, UnCompComm 
    
      openr, lunTim, RightFile, /get_lun, error=OpenStatus
      if (OpenStatus NE 0) then begin
      	print, "  > Uncompressed file does not open. Program error."
      	RmComm = 'rm ' + strtrim(RightFile,2)
      	spawn, RmComm
      endif
    endelse 
   endelse
  endwhile

  readf, lunTim, TimTitle, format='(a80)'				; title
  readf, lunTim, TimFormat, format='(a10)'			; format
  readf, lunTim, LineN, TimeN, format='(2(i6))'		; dims

  print, "  > File details: "
  print, strtrim(TimTitle,2)
  print, strtrim(TimFormat,2)
  print, LineN, TimeN
    
  if (TimeN GT MaxTime) then MaxTime = TimeN
  
  for XLine = FirstFree, (FirstFree+LineN-1) do begin
	readf, lunTim, DatumCha, format='(a80)'
        DatumCha = strtrim(DatumCha, 2)
	Name [XLine] = DatumCha				; names
  endfor

  for XTime = 0, (TimeN-1) do begin
	readf, lunTim, DatumInt, format='(i4)'
	Time [*,XTime] = DatumInt				; times
  endfor

  TimeTenN = TimeN / 10

  for XLine = FirstFree, (FirstFree+LineN-1) do begin
    for XTen = 0, (TimeTenN-1) do begin
	readf, lunTim, DatumFlt0, DatumFlt1, DatumFlt2, DatumFlt3, $
		       DatumFlt4, DatumFlt5, DatumFlt6, DatumFlt7, $ 
		       DatumFlt8, DatumFlt9, format=TimFormat
	Data [XLine,(XTen*10+0)] = DatumFlt0
	Data [XLine,(XTen*10+1)] = DatumFlt1
	Data [XLine,(XTen*10+2)] = DatumFlt2
	Data [XLine,(XTen*10+3)] = DatumFlt3
	Data [XLine,(XTen*10+4)] = DatumFlt4
	Data [XLine,(XTen*10+5)] = DatumFlt5
	Data [XLine,(XTen*10+6)] = DatumFlt6
	Data [XLine,(XTen*10+7)] = DatumFlt7
	Data [XLine,(XTen*10+8)] = DatumFlt8
	Data [XLine,(XTen*10+9)] = DatumFlt9
    endfor
  endfor

  free_lun, lunTim

  if (QCompressed NE -1) then begin
      	RmComm = 'rm ' + strtrim(RightFile,2)
      	spawn, RmComm
  endif

  FirstFree = FirstFree + LineN
endfor

for XLinFile = 1, LinFileN do begin
  LinTitle  = ""
  LinFormat = ""
  LinFile   = ""

  print, "  > Enter the path/name of .lin file: ", XLinFile
  
  OpenStatus = -1
  while (OpenStatus NE 0) do begin
    read, LinFile
    openr, lunLin, LinFile, /get_lun, error=OpenStatus
  endwhile  

  readf, lunLin, LinTitle, format='(a80)'			; title
  readf, lunLin, LinFormat, format='(a10)'			; format
  readf, lunLin, LineN, TimeN, format='(2(i6))'		; dims

  print, "  > File details: "
  print, strtrim(LinTitle,2)
  print, strtrim(LinFormat,2)
  print, LineN, TimeN
  
  
  if (TimeN GT MaxTime) then MaxTime = TimeN
  
  for XLine = FirstFree, (FirstFree+LineN-1) do begin
	readf, lunLin, DatumCha, format='(a80)'
        DatumCha = strtrim(DatumCha, 2)
	Name [XLine] = DatumCha				; names
  endfor

  for XLine = FirstFree, (FirstFree+LineN-1) do begin
    for XTime = 0, (TimeN-1) do begin
	readf, lunLin, DatumFlt, format=LinFormat
	if (DatumFlt EQ MissVal) then DatumFlt = !Values.F_NaN
	Time [XLine,XTime] = DatumFlt			; times
    endfor
  endfor

  for XLine = FirstFree, (FirstFree+LineN-1) do begin
    for XTime = 0, (TimeN-1) do begin
	readf, lunLin, DatumFlt, format=LinFormat
	if (DatumFlt EQ MissVal) then DatumFlt = !Values.F_NaN
	Data [XLine,XTime] = DatumFlt			; prec
    endfor
  endfor

  free_lun, lunLin

  FirstFree = FirstFree + LineN
endfor

for XTime = 0, (TimeMaxPoss-1) do begin
  if (Time[0,XTime] EQ MissVal) then Time [*,XTime] = !Values.F_NaN
  
  for XLine = 0, (LineMaxPoss-1) do begin
    if (Data [XLine,XTime] EQ MissVal) then Data [XLine,XTime] = !Values.F_NaN
  endfor
endfor

LineN = FirstFree
TimeN = MaxTime

print, "  > Data loaded. Now choose option ZERO."
print, ""

end

;*******************************************************************************
; recommendation for single plots: 2,6

(Choice EQ 20) : begin

print, "  > Enter the character size (1=default): "
read, MyCharSize
print, "  > Enter the character thickness (1=default): "
read, MyCharThick
print, ""

end

;*******************************************************************************
; save graph+plot specifications to .spec file

(Choice EQ 30) : begin

SaveGraphSpec, DimGraph,PlotOpt,GraphOpt,GraphNames
print, ""

end

;*******************************************************************************

(Choice EQ -1) : begin

print, "  >  0 : initialise plot (after loading)"
print, "  >  1 : load .lin file"
print, "  >  2 : change plot appearance"
print, "  >  3 : change graph defaults"
print, "  >  4 : change graph's properties"
print, "  >  5 : add plots of one line against another"
print, "  >  6 : add plots of simple lines/scatters"
print, "  >  7 : add plots of equations"
print, "  >  8 : remove lines"
print, "  >  9 : define equations"
print, "  > 10 : plot to PostScript"
print, "  > 11 : load multiple .lin files"
print, "  > 12 : change each graph y-axis"
print, "  > 13 : load a .tim file"
print, "  > 14 : load multiple .tim files"
print, "  > 15 : load multiple .tim and .lin files"
print, "  > 20 : change character size on plots"
print, "  > 30 : save plot/graph to .spec"
print, "  > 99 : exit"

end

;*******************************************************************************

else: begin

end

;*******************************************************************************

endcase
							; **** UPDATES SCREEN
if (!D.Window EQ -1) then window, /free, xsize=(3*PlotSizeFactor), ysize=(2*PlotSizeFactor), $
  		xpos=(1000-(3*PlotSizeFactor)), title="series plot"
set_plot, 'X'
erase	

for XGraph = 0, (DimGraph-1) do begin			; loops for each graph
 
 if (GraphOpt[XGraph,0] GT 0) then begin  		; is graph wanted?
  
  plot, Time[0,*], Data[0,*], $					; random line
  	Background=Black,$					; background colour
  	Color=White,$						; colour		
  	XStyle=(GraphOpt[XGraph,2]+8), $			; axis constraint ?
  	YStyle=8, $						; draws only one axis
  	XRange=[GraphOpt[XGraph,3],GraphOpt[XGraph,4]],$	; x axis limits
  	YRange=[GraphOpt[XGraph,5],GraphOpt[XGraph,6]],$	; y axis limits
  	Title=GraphNames[XGraph,0],$				; title
  	SubTitle=GraphNames[XGraph,1],$				; subtitle
  	XTitle=GraphNames[XGraph,2],$				; x axis title
  	YTitle=GraphNames[XGraph,3],$				; y axis title  	
  	XTicks=GraphOpt[XGraph,7],$				; tick marks  	
  	CharSize=MyCharSize,$ 					; size of annotations
  	CharThick=MyCharThick,$					; thickness of annotations
	XThick=MyCharThick,YThick=MyCharThick,$			; axis thicknesses
  	/NoData,font=5,position=PlotCorners[XGraph,*],/noerase
  

  if (GraphOpt[XGraph,0] EQ 1) then begin		; simple lines
  
   for XLine = 0, (LineN-1) do begin			; loops for each line

    if (GraphLines[XGraph,XLine,0] EQ 1) then begin		; is line wanted?
      
      oplot, Time[XLine,*], Data[XLine,*], $		; plot line
        Color=White, $						; colour
        LineStyle=GraphLines[XGraph,XLine,2], $			; line style
        Thick=GraphLines[XGraph,XLine,3], $			; line thickness
        PSym=GraphLines[XGraph,XLine,4]				; symbol
      
    endif
    
   endfor
   
  endif
           

  if (GraphOpt[XGraph,0] EQ 2) then begin		; one line against another
  
   for LineX = 0, (LineN-1) do begin			; loops for each line
    for LineY = 0, (LineN-1) do begin
    
     if (ScatterPlot[XGraph,LineX,LineY,0] EQ 1) then begin	; is time-line wanted?
      
      oplot, Data[LineX,*], Data[LineY,*], $		; plot line
        Color     = White, $					; colour
        LineStyle = ScatterPlot[XGraph,LineX,LineY,2], $	; line style
        Thick     = ScatterPlot[XGraph,LineX,LineY,3], $	; line thickness
        PSym      = ScatterPlot[XGraph,LineX,LineY,4]		; symbol
      
     endif
    
    endfor
   endfor
   
  endif
    

  for XLine = 0, (LineN-1) do begin			; loops for each equation
    if (GraphEq[XGraph,XLine,0] EQ 1) then begin		; is equation wanted?
      
      PointsN = 500
      Interval = double ((GraphOpt[XGraph,4] - GraphOpt[XGraph,3]) / (PointsN-1))
      AllPoints = dblarr (PointsN,2)
      AllPoints[*,*] = MissVal
      
      for XPoint = 0, (PointsN-1) do begin
        AllPoints[XPoint,0] = GraphOpt[XGraph,3] + Interval * XPoint
        AllPoints[XPoint,1] = Equations[XLine,0] $
        		    + Equations[XLine,1] * AllPoints[XPoint,0] $
        		    + Equations[XLine,2] * AllPoints[XPoint,0] * AllPoints[XPoint,0]
      endfor
      
      oplot, AllPoints[*,0], AllPoints[*,1], $			; plot line
        Color=White, $						; colour
        LineStyle=GraphEq[XGraph,XLine,2], $			; line style
        Thick=GraphEq[XGraph,XLine,3], $			; line thickness
        PSym=GraphEq[XGraph,XLine,4]				; symbol
      
    endif
  endfor
 
 endif
            
endfor

if (QInfoBar EQ 1) then begin
  if (QLogoBar EQ 1 AND QKeyBar EQ 1) then DrawKey,KeyCorners,GraphLines,GraphLinesText,GraphEq,GraphEqText, $
  	ScatterPlot,ScatterText,MyCharSize,MyCharThick,/DrawLogo,/DrawDate,/DrawAuth,/DrawKey
  if (QLogoBar EQ 1 AND QKeyBar NE 1) then DrawKey,KeyCorners,GraphLines,GraphLinesText,GraphEq,GraphEqText, $
  	ScatterPlot,ScatterText,MyCharSize,MyCharThick,/DrawLogo,/DrawDate,/DrawAuth
  if (QLogoBar NE 1 AND QKeyBar EQ 1) then DrawKey,KeyCorners,GraphLines,GraphLinesText,GraphEq,GraphEqText, $
  	ScatterPlot,ScatterText,MyCharSize,MyCharThick,/DrawKey
endif

print, "  > Main Menu: make your choice (-1=list): "
read, Choice

endwhile

while (!D.Window GE 0) do wdelete, !D.Window
print, ""

end
