; plothomogts.pro
; IDL program written by Tim Mitchell on 07.11.02
; designed to run on the outputs from homogiter.f90

pro PlotHomogTS, $
	Filter, $			; .txt files
	SavePath, $			; .eps file to save
	Suffix, $			; variable ".???"
	XSizeMulti=XSizeMulti, $	; default = 1.0
	YSizeMulti=YSizeMulti, $	; default = 1.0
	Verbose=Verbose

; *************************************** intro

Quiet=1 & if (keyword_set(Verbose)) then Quiet=0

if (Quiet EQ 0) then begin
  print, ""
  print, "  > ***** PlotHomogTS.pro: plots station time-series *****"
  print, "  > ***** you many minimise this terminal *****"
  print, ""
endif

Black = 0 & Grey = 254 & White = 255
MissVal  = -999.0 & MissCol = White
ScaleSegN = 10 & BatchFileN = 0 & GivenYear = 0 & SuspectBreak = -999
InputText = "" & GivenFile = "" & LastDumpText="standard"
RangeFract = 0.0D & ColSelect  = 0.0D
Int0=0L & Int1=0L & Int2=0L & Int3=0L & Int4=0L & Int5=0L
Int6=0L & Int7=0L & Int8=0L & Int9=0L & Int10=0L & Int11=0L
DumpWMO=0L & DumpName="" & DumpCty="" & DumpYearN=0 & DumpText="" & DumpTitle=""
MemYearAD0=-999 & MemYearAD1=-999 & QFound=-1 & DumpPlot=0

Months = [0.5,1.5,2.5,3.5,4.5,5.5,6.5,7.5,8.5,9.5,10.5,11.5]
XLabel = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec']
PlotCorners  = [0.05,0.05,0.95,0.95]
MargLeft=0.10 & MargRight=0.05 & MargTop=0.05 & MargBott=0.05

MonthWedge = (1.0-MargTop-MargBott) / 12.0
MonthCorners = fltarr (12,4)

for XMonth=0,11 do begin
  MonthCorners (XMonth,*) = [MargLeft,       (1.0-(MargTop+((XMonth+1)*MonthWedge))), $
  			     (1.0-MargRight),(1.0-(MargTop+(XMonth*MonthWedge)))]
endfor

XPixels=24 & YPixels=32
if (keyword_set(XSizeMulti)) then XPixels = XPixels * XSizeMulti
if (keyword_set(YSizeMulti)) then YPixels = YPixels * YSizeMulti

DataMin=fltarr(3,12) & DataMax=fltarr(3,12)

; *************************************** specify variable

VariableSuffix=Suffix

if            (VariableSuffix EQ ".pre") then begin
  TmpPre=1 & Divisor=10 & LimitLo=0.0 & LimitHi=MissVal & DiffRatio=1
endif else if (VariableSuffix EQ ".tmp") then begin
  TmpPre=0 & Divisor=10 & LimitLo=MissVal & LimitHi=MissVal & DiffRatio=0
endif else if (VariableSuffix EQ ".dtr") then begin
  TmpPre=0 & Divisor=10 & LimitLo=0.0 & LimitHi=MissVal & DiffRatio=0
endif else if (VariableSuffix EQ ".cld") then begin
  TmpPre=1 & Divisor=10 & LimitLo=0.0 & LimitHi=100.0 & DiffRatio=0
endif else if (VariableSuffix EQ ".spc") then begin
  TmpPre=0 & Divisor=10 & LimitLo=0.0 & LimitHi=100.0 & DiffRatio=0
endif else if (VariableSuffix EQ ".wet") then begin
  TmpPre=1 & Divisor=100 & LimitLo=0.0 & LimitHi=MissVal & DiffRatio=1
endif else if (VariableSuffix EQ ".rhm") then begin
  TmpPre=1 & Divisor=10 & LimitLo=0.0 & LimitHi=MissVal & DiffRatio=0
endif else if (VariableSuffix EQ ".vap") then begin
  TmpPre=1 & Divisor=10 & LimitLo=0.0 & LimitHi=MissVal & DiffRatio=0
endif else begin
  print, "  > @@@@@ ERROR: variable unrecognised @@@@@"
endelse

AbsScale=61 & AnoScale=62 & StDevRange=10
if (TmpPre EQ 1) then begin
  AbsScale=63 & AnoScale=64 & StDevRange=5
endif

DumpMissVal = -9999.0

; *************************************** files

GetFileBatch, Batch, BatchN, CallFilter=Filter
print, "  > Files found total: ", BatchN
  
DumpFile=Batch(0)
LastSlash=strpos(DumpFile,'/',/reverse_search)		; crua6 version
;  LastSlash=rstrpos(DumpFile,'/')			; crua4 version
SaveDir=strmid(DumpFile,0,(LastSlash+1))
XBatch=-1
  
; *************************************** main file loop

for XFile=0,(BatchN-1) do begin
  DumpFile=Batch(XFile)
    
  OriTrue = strpos(DumpFile,"oriabs")
  RefTrue = strpos(DumpFile,"refabs")
  YesTrue = strpos(DumpFile,"yesabs")

  if (OriTrue GE 0 OR RefTrue GE 0 OR YesTrue GE 0) then begin
    GrabDumpData,DumpFile,DumpData,DumpHomog,DumpYearAD,DumpWMO,DumpName,DumpCty, $
    		DumpText,DumpPlot,DumpTitle

    if (DiffRatio EQ 1 AND strmid(DumpText,0,4) NE 'Abso') then begin
      Multiply = 100.0
    endif else begin
      Multiply = Divisor
    endelse
    
    DumpData(*,*) = DumpData(*,*) / Multiply		; convert to *1.0 values
    DumpHomog(*)  = DumpHomog(*)  / Multiply

;    LastSlash   = strpos(DumpFile,"/",/Reverse_Search)	; crua6 version
    LastSlash   = rstrpos(DumpFile,"/")			; crua4 version
    FirstDigit  = LastSlash + 1
    AfterEnd    = strpos(DumpFile,".",FirstDigit)
    StnCodeText = strmid(DumpFile,FirstDigit,(AfterEnd-FirstDigit))
    StnCode     = long(StnCodeText)
    
    GrabBegEnd,DumpData,(DumpMissVal/Multiply),XYear0,XYear1
    PlotYearAD0=DumpYearAD(XYear0) & PlotYearAD1=DumpYearAD(XYear1)
    CurrentStn = StnCode

    HomogMissings = where(DumpHomog EQ (-999.0/Multiply), Count) ; correct annual
    if (Count GT 0) then DumpHomog [HomogMissings] = !Values.F_NaN
    
    Missings = where (DumpData EQ (DumpMissVal/Multiply), Count) ; correct monthly
    if (Count GT 0) then DumpData [Missings] = !Values.F_NaN
    
    if            (OriTrue GE 0) then begin
      OriData = reform(DumpData(*,XYear0:XYear1))
      for XMonth=0,11 do begin
        ValMin=min(OriData(XMonth,*),max=ValMax,/nan)
        DataMin(0,XMonth) = ValMin & DataMax(0,XMonth) = ValMax
      endfor
    endif else if (RefTrue GE 0) then begin
      RefData = reform(DumpData(*,XYear0:XYear1))
      for XMonth=0,11 do begin
        ValMin=min(RefData(XMonth,*),max=ValMax,/nan)
        DataMin(1,XMonth) = ValMin & DataMax(1,XMonth) = ValMax
      endfor
    endif else if (YesTrue GE 0) then begin
      YesData = reform(DumpData(*,XYear0:XYear1))
      for XMonth=0,11 do begin
        ValMin=min(YesData(XMonth,*),max=ValMax,/nan)
        DataMin(2,XMonth) = ValMin & DataMax(2,XMonth) = ValMax
      endfor
    endif

    Years = DumpYearAD(XYear0:XYear1) & YearN=XYear1-XYear0+1
  endif
endfor

; *************************************** identify decades

YearADFlt = float(Years)/10.0
YearADInt = round(YearADFlt)
XTickVal  = where (float(YearADInt) EQ YearADFlt, XTickCount)    
YearADInt = YearADInt * 10
    
if (XTickcount eq 0) then begin	; no decade data range, do start/end instead
    	YearADInt = Years
    	YearADIntDim = size (YearADInt)
    	XTickcount = 2
    	XTickval = intarr(XTickcount)
    	XTickBlank = strarr(XTickcount) & XTickBlank(*)=' '
    	XTickOff = findgen(XTickCount)
    	XTickval(*) = [0,YearADIntDim[1]-1]
endif
    
; *************************************** set up plot

Set_Plot, 'ps', /copy
device, filename=SavePath, bits_per_pixel=8, xsize=XPixels, ysize=YPixels, $
      		/encapsulated

; *************************************** plot loop

for XMonth=0,11 do begin
  WyeMin=min(DataMin(*,XMonth)) & WyeMax=max(DataMax(*,XMonth))
  WyeRange=(WyeMax-WyeMin) & WyeMid=(WyeMin+WyeMax)/2.0
  WyeLo=WyeMin-(WyeRange/20.0) & WyeHi=WyeMax+(WyeRange/20.0)
  WyeTickLo=WyeMin+(WyeRange/10.0) & WyeTickHi=WyeMax-(WyeRange/10.0)
  
  if (XMonth LT 11) then begin
    plot, Years,OriData(XMonth,*), position=MonthCorners(XMonth,*), $
  	xrange=[PlotYearAD0,PlotYearAD1], yrange=[WyeLo,WyeHi], $
    	color=Black,/noerase,charsize=1.0,font=5,thick=2, $
    	xstyle=5, $
    	ystyle=1,yticks=2,yticklen=-0.01,ytickformat='(i3)', $
    	ytickv=[WyeTickLo,WyeMid,WyeTickHi]
  endif else begin
    plot, Years,OriData(XMonth,*), position=MonthCorners(XMonth,*), $
  	xrange=[PlotYearAD0,PlotYearAD1], yrange=[WyeLo,WyeHi], $
    	color=Black,/noerase,charsize=1.0,font=5,thick=2, $
    	xstyle=9,xticks=XTickCount-1,xtickv=YearADInt[XTickVal], $
    	xticklen=-0.04,xminor=10, $
    	ystyle=1,yticks=2,yticklen=-0.01,ytickformat='(i3)', $
    	ytickv=[WyeTickLo,WyeMid,WyeTickHi]
  endelse
  
  for XTick=0,(XTickCount-1) do begin
    plots,[YearADInt[XTickVal(XTick)],YearADInt[XTickVal(XTick)]], $
    	[WyeLo,WyeHi],linestyle=1
  endfor
    	
  plots,[PlotYearAD0,PlotYearAD1],[WyeHi,WyeHi],linestyle=0
  xyouts,0.01,((MonthCorners(XMonth,1)+MonthCorners(XMonth,3))/2.0), $
  		XLabel(XMonth),/normal,alignment=0.0,charsize=1.0,font=5
  
  oplot,Years,RefData(XMonth,*),linestyle=1,thick=2
  oplot,Years,YesData(XMonth,*),linestyle=2,thick=2
endfor

; *************************************** end plot

device, /close
set_plot, 'X'	

if (Quiet EQ 0) then print, ""

end 
