; plotday.pro
; IDL program written by Tim Mitchell on 14.2.01
; designed to plot the data in a single .day file

; *********************************************************************
; initial

White = 255 & Grey = 254 & Black = 0

MissVal = -999.0 & MissColour = Grey
MyCharSize = 1 & MyCharThick = 1
MonthN = 12 & DayN = 31 & JulianN = 366
XGridSet = 0 & YGridSet = 0
SideLenPS = 16 & UnitArea = 1.0
QRainbow = 0

set_plot, 'X'

GetScales, ScaleN, ScaleName, ScaleColTab, ScaleSeg, ScaleLimits

print, "   > Enter the number of columns of data to include: "
read, ColN

if (ColN GT 1) then begin
  print, "   > Enter the first, last years AD: "
  read, Year0, Year1
  
  PlotYear0 = Year0 & PlotYear1 = Year1
  YearN     = Year1 - Year0 + 1

  YearAD    = intarr (YearN)
  for XYear = 0, (YearN-1) do begin
    YearAD(XYear) = Year0 + XYear
  endfor
  
  GetMonthLengths, YearAD, MonthLengths
  
  Daily         = fltarr (ColN,YearN,JulianN)
  Daily [*,*,*] = 0.0					; initialise to zero --> non-exist Feb 29ths = 0.0    
endif else begin
  LoadDay, YearAD, FileData
  
  Dims  = size (FileData)
  YearN = Dims (1) 
  PlotYear0 = YearAD(0) & PlotYear1 = YearAD(YearN-1)
  
  Daily         = fltarr (ColN,YearN,JulianN)
  Daily [*,*,*] = 0.0  
  
  GetMonthLengths, YearAD, MonthLengths
  
  for XYear = 0, (YearN-1) do begin
    XJulian = -1

    for XMonth = 0, (MonthN-1) do begin
      for XDay = 0, (MonthLengths(XYear,XMonth)-1) do begin
        XJulian = XJulian + 1
        
        Daily(0,XYear,XJulian) = FileData(XYear,XMonth,XDay)
      endfor
      
      if (XMonth EQ 1 AND MonthLengths(XYear,XMonth) EQ 28) then XJulian = XJulian + 1
    endfor
  endfor
  
  FileData = 0
endelse

PSColours     = intarr (ColN,YearN,JulianN)
PSColours [*] = Grey
  
;******************************************************************************
; main loop

Choice = 78

while (Choice LT 99) do begin
	
case 1 of
	
;******************************************************************************
; load .day

(Choice EQ 1): begin	

if (ColN GT 1) then begin						; obtain column to fill
  print, "  > Enter the column to fill: "
  read, XCol
endif else begin
  XCol = 0
endelse

LoadDay, FileYearAD, FileData						; load .day file
    
Dims      = size (FileYearAD)						; find file length in years
FileYearN = Dims(1)

XYear      =  0								; find corresponding years AD
XMainYear0 = -1 & XFileYear0 = -1

while (XMainYear0 LT 0 AND XYear LT YearN) do begin
  if (YearAD(XYear) EQ FileYearAD(0)) then XMainYear0 = XYear
  if (YearAD(XYear) EQ FileYearAD(0)) then XFileYear0 = 0
  XYear = XYear + 1
endwhile

if (XMainYear0 LT 0) then begin
 while (XMainYear0 LT 0 AND XYear LT FileYearN) do begin
  if (YearAD(0) EQ FileYearAD(XYear)) then XMainYear0 = 0
  if (YearAD(0) EQ FileYearAD(XYear)) then XFileYear0 = XYear
  XYear = XYear + 1
 endwhile
endif

if (XMainYear0 LT 0) then begin
  print, "  > Unable to find corresponding period in main array."
endif else begin
  CommonYearN = (YearN-XMainYear0) < (FileYearN-XFileYear0)		; find common length (years)
  
  print, "  > Common period: ", YearAD(XMainYear0), YearAD(XMainYear0+CommonYearN-1)

  Daily (XCol,*,*) = 0.0						; reinitialise column
  
  XFileYear = XFileYear0 - 1 & XMainYear = XMainYear0 - 1
  for XYear = 0, (CommonYearN-1) do begin
    XJulian   = -1 
    XFileYear = XFileYear + 1
    XMainYear = XMainYear + 1

    for XMonth = 0, (MonthN-1) do begin
      for XDay = 0, (MonthLengths(XMainYear,XMonth)-1) do begin
        XJulian = XJulian + 1
        
        Daily(XCol,XMainYear,XJulian) = FileData(XFileYear,XMonth,XDay)		; transfer datum
      endfor
      
      if (XMonth EQ 1 AND MonthLengths(XMainYear,XMonth) EQ 28) then XJulian = XJulian + 1
    endfor
  endfor
  
  FileYearAD = 0 & FileData = 0
endelse
  
end

;******************************************************************************
; alter plot appearance

(Choice EQ  2): begin	

print, "  > Current min and max years:   ", PlotYear0, PlotYear1
print, "  > Enter the new years: "
read, PlotYear0, PlotYear1

print, "  > Current character size:      ", MyCharSize
print, "  > Enter the new size: "
read, MyCharSize

print, "  > Current character thickness: ", MyCharThick
print, "  > Enter the new thickness: "
read, MyCharThick

print, "  > Current grid lines (1=yes) X,Y:   ", XGridSet, YGridSet
print, "  > Enter the new grid settings: "
read, XGridSet, YGridSet

print, "  > Current .eps square side length:   ", SideLenPS
print, "  > Enter the new length: "
read, SideLenPS

print, "  > Current areal unit size of circles:   ", UnitArea
print, "  > Enter the new size: "
read, Unitarea

end

;******************************************************************************
; select plot colours

(Choice EQ  9): begin	

print, "  > Vary .eps colours by area (1=yes):   ", QRainbow
print, "  > Enter the new setting: "
read, QRainbow

if (QRainbow EQ 1) then begin
 QScale = -2
 while (QScale LT 0 OR QScale GT (ScaleN-1)) do begin
  print, "  > Select the colour scale (-1=list): "
  read, QScale
  if (QScale EQ -1) then begin
   for XScale = 0, (ScaleN-1) do begin
    print, XScale, " : ", ScaleName[XScale], ScaleLimits[XScale,0], ScaleLimits[XScale,1], $
  		 format='(i4,a3,a10,2f10.2)'
   endfor
  endif
 endwhile
endif else begin
 print, "  > Select the colour table: "
 read, QScale
endelse

end

;******************************************************************************
; calculate colours (10)

(Choice EQ 10): begin	

if (QRainbow EQ 1) then begin
 loadanyct, ScaleColTab(QScale)

 for XCol = 0, (ColN-1) do begin
  for XYear = 0, (YearN-1) do begin
   ColSeries = ColourSeries (reform(Daily(XCol,XYear,*)),reform(ScaleLimits(QScale,*)),MissColour)
   PSColours (XCol,XYear,*) = ColSeries
  endfor
 endfor
endif else begin
 loadanyct, QScale

 print, "  > Select colour index for each column in turn: "
 for XCol = 0, (ColN-1) do begin
   read, Colour
   PSColours(XCol,*,*) = Colour
 endfor
endelse

end

;******************************************************************************
; plot image to screen (11) or .eps (12)

(Choice EQ 11 OR Choice EQ 12): begin	

loadanyct, 4
if (!D.Window EQ -1) then window, /free, xsize=400, ysize=400, xpos=600, title=".day circle plot"

if (Choice EQ 11) then begin
  BGCol = Black & FGCol = White
  
  InitDayPlot, PlotYear0,PlotYear1, Black,White, MyCharSize,MyCharThick, XGridSet,YGridSet
  PlotCircle, YearAD, Daily, PSColours, PlotYear0,PlotYear1, White, /screen 
endif else begin
  PSPath = ""
  print, "  > Enter the filepath of the .eps file: "
  read, PSPath

  Set_Plot, 'ps', /copy
  device, filename=PSPath, bits_per_pixel=8, /Color, /encapsulated, xsize=SideLenPS, ysize=SideLenPS

  BGCol = White & FGCol = Black

  InitDayPlot, PlotYear0,PlotYear1, White,Black, MyCharSize,MyCharThick, XGridSet,YGridSet
  PlotCircle, YearAD, Daily, PSColours, PlotYear0,PlotYear1, MissColour, SpecUnitArea=UnitArea
  
  device, /close
endelse

set_plot, 'X'	

end

; *****************************************************************************
; end of main loop

else: begin
	print, "  >  1 : load .day"
	print, "  >  2 : alter plot appearance"
	print, "  >  9 : set plot colours"
	print, "  > 10 : set data colours"
	print, "  > 11 : plot image to screen"
	print, "  > 12 : plot image to .eps"
	print, "  > 99 : end"	
end

endcase
        
        print, ""
	print, "  > Main menu: Enter a number:"
	read, Choice
	
endwhile

; *****************************************************************************
; wind down

while (!D.Window GE 0) do wdelete, !D.Window

print, ""

end
