; getmarknewglo.pro
; written by Tim Mitchell on 27.01.03
; program to extract from IDL integer binary format to .glo

MonthStrings = ['01','02','03','04','05','06','07','08','09','10','11','12']

ModelChosen = -999
print,"Determine main grid"
SelectModel, ModelChosen, ModelFilePath, ModelLongN, ModelLatN

FilePath = ""
print,"Enter load filepath"
read,FilePath

GridSize=0.0
print,"Enter grid spacing"
read,GridSize

SpecJan=""
print,"Enter save filepath of January (.mm.glo is auto): "
read,SpecJan

TitlJan=""
print,"Enter save title of January file ('mon=mm' is auto): "
read,TitlJan

rdbin,Data,FilePath,gridsize=GridSize	; for info, type 'rdbin' at prompt

GloFile=SpecJan & GloTitl=TitlJan
for XMonth=0,11 do begin
  GloFile = SpecJan + '.' + MonthStrings(XMonth) + '.glo'
  GloTitl = TitlJan + ' mon=' + MonthStrings(XMonth)
  GloSlice = reform(Data(*,*,XMonth))
  saveglo,ModelChosen,GloSlice,CallFile=GloFile,CallTitle=GloTitl
endfor

end
