; getmarknew.pro
; written by Tim Mitchell on 28.09.00
; last modified on 28.09.00
; program to extract from IDL integer binary format to .mon

SourcePath = '/cru/scratch2/f709762/test1546'
SavePath   = '/cru/scratch2/f709762/'
SourceFile = 'blank'
SaveFile   = 'blank'

FileLoadN = 0
FileMissN = 0
FileSaveN = 0

EightN = 720/8
     
for ADYear = 2000, 2000 do begin
  ValidN = 0L

  TextADYear = string (ADYear)  
  SourceFile = SourcePath + strtrim(TextADYear,2)			; original file v1
  SourceFile = strtrim(SourceFile,2)
  
  openr, lunSource, SourceFile, /get_lun, error=OpenStatus		; attempt to open v1  
  
  FileFound = 0  
  if (OpenStatus EQ 0) then begin					; ...successful
    FileFound = 1
    free_lun, lunSource
  endif else begin							; ...unsuccessful
    SourceFile = SourceFile + '.Z'						; original file v2
    SourceFile = strtrim (SourceFile,2)
    
    openr, lunSource, SourceFile, /get_lun, error=OpenStatus			; attempt to open v2

    if (OpenStatus EQ 0) then begin						; ...successful
      free_lun, lunSource
      FileFound  = 1
    endif
  endelse
  
  if (FileFound EQ 0) then begin
     print, "  > No file found for year: ", ADYear
     FileMissN = FileMissN + 1 
  endif else begin
     RDBin,Data,SourceFile,/Quiet					; Mark New routine
     print, "  > File loaded for year: ", ADYear
     FileLoadN = FileLoadN + 1
     
     print, "  > Array has total elements: ", n_elements (Data)
     
     SaveFile = SavePath + strtrim(TextADYear,2) + '.dat'		; save as dat file
     SaveFile = strtrim (SaveFile,2)
     openw, lunSave, SaveFile, /get_lun
     
     for XMonth = 0, 11 do begin
       for XLat = 0, 359 do begin
         for XLong = 0, 719 do begin
           if (Data(XLong,XLat,XMonth) NE -9999.0) then ValidN = ValidN + 1
         endfor
       endfor
     endfor
     
     print, "  > Valid data: ", ValidN
     
     for XMonth = 0, 11 do begin
       for XLat = 0, 359 do begin
         for XEight = 0, (EightN-1) do begin
           Datum0 = Data(((XEight*8)+0),XLat,XMonth)
           Datum1 = Data(((XEight*8)+1),XLat,XMonth)
           Datum2 = Data(((XEight*8)+2),XLat,XMonth)
           Datum3 = Data(((XEight*8)+3),XLat,XMonth)

           Datum4 = Data(((XEight*8)+4),XLat,XMonth)
           Datum5 = Data(((XEight*8)+5),XLat,XMonth)
           Datum6 = Data(((XEight*8)+6),XLat,XMonth)
           Datum7 = Data(((XEight*8)+7),XLat,XMonth)
           
           printf, lunSave, Datum0,Datum1,Datum2,Datum3,Datum4,Datum5,Datum6,Datum7, format='(8e16.7)'
         endfor
       endfor
     endfor
     
     print, "  > File saved for year:  ", ADYear
     FileSaveN = FileSaveN + 1
     
     free_lun, lunSave
     
;     Command = 'compress ' + SaveFile + ' &'
;     Spawn, Command
  endelse
endfor

print, "  > Files loaded, saved, missing:", FileLoadN, FileSaveN, FileMissN

end
