; getblank.pro
; written by Tim Mitchell on 28.09.00
; last modified on 28.09.00
; program to mimic a Mark New year file, but as a blank year

TextADYear = '1900'

SavePath   = '/cru/mikeh1/f709762/temk/marknew/halfdeg-temp-'
SaveFile   = 'blank'

Missing = -9999.0
EightN  = 720/8
     
SaveFile = SavePath + strtrim(TextADYear,2) + '.dat'		; save as dat file
SaveFile = strtrim (SaveFile,2)
openw, lunSave, SaveFile, /get_lun

Data         = fltarr (720,360,12)
Data (*,*,*) = Missing
     
for XMonth = 0, 11 do begin
       for XLat = 0, 359 do begin
         for XEight = 0, (EightN-1) do begin
           Datum0 = Data(((XEight*8)+0),XLat,XMonth)
           Datum1 = Data(((XEight*8)+1),XLat,XMonth)
           Datum2 = Data(((XEight*8)+2),XLat,XMonth)
           Datum3 = Data(((XEight*8)+3),XLat,XMonth)

           Datum4 = Data(((XEight*8)+4),XLat,XMonth)
           Datum5 = Data(((XEight*8)+5),XLat,XMonth)
           Datum6 = Data(((XEight*8)+6),XLat,XMonth)
           Datum7 = Data(((XEight*8)+7),XLat,XMonth)
           
           printf, lunSave, Datum0,Datum1,Datum2,Datum3,Datum4,Datum5,Datum6,Datum7, format='(8e16.7)'
         endfor
       endfor
endfor

free_lun, lunSave
     
end
