; program to construct cloud correlation coefficients (with DTR)
; method approximately follows New et al 2000
; this program is required because Mark New has lost both
;	the correlation data file, and construction files
; written by Tim Mitchell 10.01.03

pro CloudCorr

MissVal=-999.0 & Ratio=1.0

NYear=20
MonthNum = strarr(12)
MonthNum = ['01','02','03','04','05','06','07','08','09','10','11','12']
CLD = fltarr (NYear,12,72,36) & DTR = fltarr (NYear,12,72,36)
Aye = fltarr (12,72,36) & Bee = fltarr (12,72,36)
Aye(*,*,*) = MissVal & Bee(*,*,*) = MissVal

print,"loading..."
for XYear = 0, NYear-1 do begin		; load the data
  YearAD = 1971 + XYear
  
  for XMonth = 0, 11 do begin
    fileCLD = "/cru/tyn1/f709762/scratch/cld7190." + strtrim(MonthNum(XMonth),2) + "." + $
    			strtrim(string(YearAD),2) + ".glo"
    loadglo,23,CLDmon,fileCLD,fileinfo,/silent
    CLD (XYear,XMonth,*,*) = CLDmon (*,*)
    
    fileDTR = "/cru/tyn1/f709762/scratch/dtr7190." + strtrim(MonthNum(XMonth),2) + "." + $
    			strtrim(string(YearAD),2) + ".glo"
    loadglo,23,DTRmon,fileDTR,fileinfo,/silent
    DTR (XYear,XMonth,*,*) = DTRmon (*,*)
  endfor
endfor

print,"regressing..."
for XLon = 0, 71 do begin		; now do the correlations
 for XLat = 0, 35 do begin
  for XMonth = 0, 11 do begin
    DTRvec = reform(DTR(*,XMonth,XLon,XLat))
    CLDvec = reform(CLD(*,XMonth,XLon,XLat))
    robust_reg_tdm,DTRvec,CLDvec,Kay1,Kay2,YFit,-1,miss=0.0,Ratio=Ratio
    if finite(Kay1) and finite(Kay2) and finite(Ratio) then begin
      if Ratio LT 0.3 then begin
        Aye(XMonth,XLon,XLat) = Kay1 & Bee(XMonth,XLon,XLat) = Kay2
      endif
    endif
  endfor
 endfor
endfor

print,"saving 5.0 ..."
for XMonth = 0, 11 do begin
  savefileA="/cru/tyn1/f709762/cru_ts_2.0/_constants/_7190/a.7190." + strtrim(MonthNum(XMonth),2) + ".txt"
  savefileB="/cru/tyn1/f709762/cru_ts_2.0/_constants/_7190/b.7190." + strtrim(MonthNum(XMonth),2) + ".txt"
  openw, lunSaveA, savefileA, /get_lun
  openw, lunSaveB, savefileB, /get_lun
  for XLon = 0, 71 do begin
    for XLat = 0, 35 do begin
      if (Aye(XMonth,XLon,XLat) NE MissVal AND Bee(XMonth,XLon,XLat) NE MissVal) then begin
      	if (abs(Aye(XMonth,XLon,XLat)) LE 99999 AND abs(Bee(XMonth,XLon,XLat)) LE 99999) then begin
      	  lat = ((float(xlat)+0.5) * 5.0) -  90.0
      	  lon = ((float(xlon)+0.5) * 5.0) - 180.0
      	  printf,lunSaveA,lat,lon,1.0,Aye(XMonth,XLon,XLat),1.0,format="(2f8.2,f8.1,f13.5,i7)"
      	  printf,lunSaveB,lat,lon,1.0,Bee(XMonth,XLon,XLat),1.0,format="(2f8.2,f8.1,f13.5,i7)"
        endif
      endif
    endfor
  endfor
  free_lun, lunSaveA
  free_lun, lunSaveB
endfor

print,"interpolating to 2.5 ..."
quick_interp_tdm2,7190,7190,"/cru/tyn1/f709762/cru_ts_2.0/_constants/_7190/a.25.",1000,/info, $
   binfac=1000.0,gs=2.5,pts_prefix="/cru/tyn1/f709762/cru_ts_2.0/_constants/_7190/a.",/dumpbin,/dumpglo
quick_interp_tdm2,7190,7190,"/cru/tyn1/f709762/cru_ts_2.0/_constants/_7190/b.25.",1000,/info, $
   binfac=1000.0,gs=2.5,pts_prefix="/cru/tyn1/f709762/cru_ts_2.0/_constants/_7190/b.",/dumpbin,/dumpglo

;savemon,"/cru/tyn1/f709762/cru_ts_2.0/_constants/_7190/cld-dtr-a.mon",Aye,36,72
;savemon,"/cru/tyn1/f709762/cru_ts_2.0/_constants/_7190/cld-dtr-b.mon",Bee,36,72
;for XMonth = 0, 11 do begin
;  savefileA = "/cru/tyn1/f709762/cru_ts_2.0/_constants/_7190/cld-dtr-a." + strtrim(MonthNum(XMonth),2) + ".glo"
;  savetitleA = "cld v dtr corr-a mon=" + strtrim(MonthNum(XMonth),2)
;  sliceA = reform(Aye(XMonth,*,*))
;  SaveGlo,23,sliceA,CallFile=savefileA,CallTitle=savetitleA
;  
;  savefileB = "/cru/tyn1/f709762/cru_ts_2.0/_constants/_7190/cld-dtr-b." + strtrim(MonthNum(XMonth),2) + ".glo"
;  savetitleB = "cld v dtr corr-b mon=" + strtrim(MonthNum(XMonth),2)
;  sliceB = reform(Bee(XMonth,*,*))
;  SaveGlo,23,sliceB,CallFile=savefileB,CallTitle=savetitleB
;endfor

end
