pro cal_cld_gts_tdm,dtr_prefix,outprefix,year1,year2,info=info

; calculates cld anomalies using relationship with dtr anomalies
; reads coefficients from predefined files (*1000)
; reads DTR data from binary output files from quick_interp_tdm2.pro (binfac=1000)
; creates cld anomaly grids at dtr grid resolution
; output can then be used as dummy input to splining program that also 
;  includes real cloud anomaly data
;
if n_params() lt 1 then begin
 print,'cal_cld_gts,dtr_prefix,outprefix,year1,year2,[nor1,nor2]'
 return
endif
if n_elements(nor1) eq 0 then nor1=1961
if n_elements(nor2) eq 0 then nor2=1990

MonthNum = strarr(12)
MonthNum = ['01','02','03','04','05','06','07','08','09','10','11','12']

; unnecessary because 61-90 normals have already been created
; print, "@@@@@ looking for 2.5 deg DTR 1961-90 @@@@@"
; mean_gts,'~/m1/gts/dtr/glo25/glo25.dtr.',nor1,nor2
; mean_gts_tdm,'/cru/mark1/f080/gts/dtr/glo25/glo25.dtr.',nor1,nor2

;print, "@@@@@ looking for 2.5 deg DTR normal @@@@@"
;; rdbin,dtrnor,'~/m1/gts/dtr/glo25/glo25.dtr.'+string(nor1-1900,nor2-1900,form='(2i2.2)')
;dtrnorstr='/cru/mark1/f080/gts/dtr/glo25/glo25.dtr.'+string(nor1-1900,nor2-1900,form='(2i2.2)')
;rdbin,dtrnor,dtrnorstr

if keyword_set(info) then printf,-1,"      MEAN    AV MAG   STD DEV",format="(18x,a30)"

rdbin,a,'/cru/tyn1/f709762/cru_ts_2.0/_constants/_7190/a.25.7190',gridsize=2.5
rdbin,b,'/cru/tyn1/f709762/cru_ts_2.0/_constants/_7190/b.25.7190',gridsize=2.5

defxyz,lon25,lat25,2.5
defxyz,lon05,lat05,0.5

for iy=year1,year2 do begin
 rdbin,dtr,dtr_prefix+string(iy,form='(i4)'),gridsize=2.5

 if keyword_set(info) then begin
  dumpvalid=where(dtr NE 0,dumpvalidn)
  mean=mean(dtr(dumpvalid)) & avmag=mean(abs(dtr(dumpvalid))) & stddev=stddev(dtr(dumpvalid))
  printf,-1,"DTR  ",iy," non-zero",mean,avmag,stddev," cells=",dumpvalidn,format="(a5,i4,a,3f10.4,a,i9)"
 endif

 cld=dtr
 for im=0,11 do begin
 
  for lat=0,71 do begin
   for lon=0,143 do begin
    if dtr(lon,lat,im) gt -9999 then begin
;     cld(lon,lat,im)=a(lon,lat,im)/100.0+(b(lon,lat,im)/100.0)* $
;     			((dtr(lon,lat,im)-dtrnor(lon,lat,im))/10.0)
     cld(lon,lat,im)=a(lon,lat,im)/1000.0+(b(lon,lat,im)/1000.0)* (dtr(lon,lat,im)/1000.0)
    endif
   endfor
  endfor
  
  savefileA = outprefix + string(iy,form='(i4)') + '.' + strtrim(MonthNum(im),2) + ".glo"
  savetitleA = "moose"
  sliceA = reform(cld(*,*,im))
  SaveGlo,22,sliceA,CallFile=savefileA,CallTitle=savetitleA

 endfor
 wrbin,cld,outprefix+string(iy,form='(i4)')
endfor
end
