// Constants and global objects
var FL_TOO_LOW_VERSION  = 3;
var FL_INSTALLED        = 2;
var FL_NOT_INSTALLED    = 1;
var FL_UNKNOWN          = 0;
var FL_REQUIRED_VERSION = 8;
var flashObjects        = new Array();
var flashType           = 'application/x-shockwave-flash';

// Initiates the Flash detection
function initFlash() {
  // If there aren't any Flash objects on the page, don't continue
  if (!isFlashOnPage()) return;

  var flashInstalled  = FL_UNKNOWN;
  var flashVersion    = 0;

  if (navigator.plugins && navigator.plugins.length) {
    var x = navigator.plugins["Shockwave Flash"];

    if (x) {
      flashInstalled = FL_INSTALLED;

      if (x.description) {
        var y         = x.description;
        flashVersion  = y.charAt(y.indexOf('.')-1);
      }
    } else {
      flashInstalled  = FL_NOT_INSTALLED;
    }

    if (navigator.plugins["Shockwave Flash 2.0"]) {
      flashInstalled  = FL_INSTALLED;
      flashVersion    = 2;
    }
  } else if (navigator.mimeTypes && navigator.mimeTypes.length) {
    x = navigator.mimeTypes[flashType];

    if (x && x.enabledPlugin) {
      flashInstalled = FL_INSTALLED;
    } else {
      flashInstalled = FL_NOT_INSTALLED;
    }
  } else {
    var fromVersion = 2;
    var toVersion   = 8;

    for (var i = fromVersion; i <= toVersion; i++) {
      try {
        var flash = new ActiveXObject('ShockwaveFlash.ShockwaveFlash.' + i);

        if (flash) {
          flashInstalled = FL_INSTALLED;
          flashVersion   = i;
        }
      } catch (e) {}
    }
  }

  switch (flashInstalled) {
    case FL_INSTALLED:
      if (flashVersion < FL_REQUIRED_VERSION) {
        flashAlert(FL_TOO_LOW_VERSION);
      }
      break;

    case FL_NOT_INSTALLED:
      flashAlert(FL_NOT_INSTALLED);
      break;

    case FL_UNKNOWN:
      flashAlert(FL_UNKNOWN);
      break;
  }
} // initFlash

function flashAlert(errorType) {
  var errorDiv = document.createElement('div');

  for (var i = 0; i < flashObjects.length; i++) {
    var object = flashObjects[i];

    switch (errorType) {
      case FL_TOO_LOW_VERSION:
        errorDiv.appendChild(document.createTextNode('For gammel versjon av Flash.'));
        break;

      case FL_NOT_INSTALLED:
        errorDiv.appendChild(document.createTextNode('Flash er ikke innstallert.'));
        break;

      case FL_UNKNOWN:
        errorDiv.appendChild(document.createTextNode('Det er et problem med Flash-innstallasjonen din.'));
        break;
    }

    object.parentElement.replaceChild(errorDiv, object);
  }
} // flashAlert

// Iterates over the <object> elements on the page and checks if they are valid
// Flash objects. If so, returns 'true', if not returns 'false'.
function isFlashOnPage() {
  var objects   = document.getElementsByTagName('object');
  if (!objects || (objects.length == 0)) return false;

  for (var i = 0; i < objects.length; i++) {
    var object = objects[i];

    // If the object elements @type matches the Flash MIME type, continue
    if (object.getAttribute('type') == flashType) {
      flashObjects.push(object);
    }
  }

  return (flashObjects.length > 0);
} // isFlashOnPage

addEvent(window, 'load', initFlash);